<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hoteles;
use App\Hoteles_contactos;
use App\User;
use App\Notifications\Codigo;
use Auth;

class ReclamarHotelesController extends Controller
{
    public function index($id){
    	$hotel = Hoteles::find($id);

    	if (is_null($hotel)) {
    		abort(404);
    		exit();
    	}else{
    		if ($hotel->reclamar=='S') {
	    		return view('reclamar',compact('hotel'));
	    	}else{
	    		return redirect()->route('hotel.single',$hotel->url);
	    	}
    	}    	
    }

    public function reclamar($id){        

        $hotel = Hoteles::find($id);

        if (is_null($hotel)) {
            abort(404);
            exit();
        }else{

            if (Auth::user()->rol_id==3) {
                return redirect()->route('hotel.single',$hotel->url);
            }else{
                if ($hotel->reclamar=='S') {
                    return view('confirmacion',compact('hotel'));
                }else{
                    return redirect()->route('hotel.single',$hotel->url);
                }
            }            
        }  
    }

    public function enviar_codigo(Request $request){

        $code = generar_code(16);

        session(['code' => $code]);

        $contacto = Hoteles_contactos::find($request->id_email);

        if ($contacto->id_hotel == $request->id_hotel) {
            
            $user = User::find(Auth::user()->id);
            $user->email = $contacto->email;
            $user->code = $code;
            $user->notify(new Codigo());            
            return 0;
        }else{
            return 1;
        }
    }

    public function validar_codigo(Request $request){

        $code = session('code');

        if ($code==$request->code) {

            $hotel = Hoteles::find($request->id_hotel);
            $hotel->user_id = Auth::user()->id;
            $hotel->reclamar = 'N';
            $hotel->save();

            return 0;
        }else{
            return 1;
        }

    }   


}
