<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Servicios;

class ServiciosController extends Controller
{
    public function index(){
    	$servicios = Servicios::whereNull('id_servicio')->orderby('id','desc')->get();
    	$i=1;
    	return view('admin.servicios.index',compact('servicios','i'));
    }

    public function create(){
        return view('admin.servicios.create');
    }

    public function store(Request $request){

        $buscar = Servicios::all()->where('servicio',$request->servicio)->count();

        if ($buscar >0) {
            return redirect()->back()->with('error_servicio','El servicio '.$request->servicio.' ya se encuentra registrado');
        }

        $servicio = new Servicios();
        $servicio->servicio = $request->servicio;

        $file    = $request->file('foto');

        if ($file) {
            $file    = $request->file('foto');
            $name    = $file->getClientOriginalName();
            $code = generar_code(4);
            $name = $code.'-'.$name;
            \Storage::disk('servicios')->put($name,  \File::get($file));
            $url_img = "/img/servicios/".$name;

            $servicio->img = $url_img;
            $servicio->principal = 'S';
        }else{
            $servicio->principal = 'N';
        }

        $servicio->save();

        return redirect()->route('servicios.index')->with('success','Registrado')->with('mensaje','Servicio registrado con éxito');

    }

    public function edit($id){
        $servicio = Servicios::find($id);
        return view('admin.servicios.edit',compact('servicio'));
    }

    public function update($id,Request $request){


        $buscar = Servicios::all()->where('servicio',$request->servicio)->where('id','!=',$id)->count();

        if ($buscar >0) {
            return redirect()->back()->with('error_servicio','El servicio '.$request->servicio.' ya se encuentra registrado');
        }

        $servicio = Servicios::find($id);
        $servicio->servicio = $request->servicio;

        $file    = $request->file('foto');

        if ($file) {
            $file    = $request->file('foto');
            $name    = $file->getClientOriginalName();
            $code = generar_code(4);
            $name = $code.'-'.$name;
            \Storage::disk('servicios')->put($name,  \File::get($file));
            $url_img = "/img/servicios/".$name;

            $servicio->img = $url_img;
            $servicio->principal = 'S';
        }

        $servicio->save();

        return redirect()->route('servicios.index')->with('success','Actualizado')->with('mensaje','Servicio actualizado con éxito');
    }

    public function delete($id){
    	$delete = Servicios::find($id);
    	$delete->delete();
  		return redirect()->back()->with('success','Eliminado')->with('mensaje','Servicio eliminado con éxito');
    }
}
