<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Hoteles extends Model
{
    public function categoria(){
        return $this->belongsTo('App\Categorias','id_categoria','id');
    }
    public function ubicacion (){
        return $this->belongsTo('App\Hoteles_ubicaciones','id','id_hotel');
    }

    public function imagenes(){
    	return $this->hasMany(Hoteles_imagenes::class,'id_hotel','id');
    }

    public function servicios(){
    	return $this->hasMany(Hoteles_servicios::class,'id_hotel','id');
    }

    public function contactos(){
    	return $this->hasMany(Hoteles_contactos::class,'id_hotel','id');
    }

    public function count_telefono(){
        return Hoteles_contactos::where('id_hotel',$this->id)->whereNotNull('telefono')->count();
    }

    public function count_email(){
        return Hoteles_contactos::where('id_hotel',$this->id)->whereNotNull('email')->count();
    }

    public function recomendaciones(){
    	return $this->hasMany(Hoteles_recomendaciones::class,'id_hotel','id');
    }

    public function tarjetas(){
    	return $this->hasMany(Hoteles_tarjetas::class,'id_hotel','id');
    }

    public function habitaciones(){
    	return $this->hasMany(Habitaciones::class,'id_hotel','id')->where('borrado','N');
    }

    public function comentarios(){
        return $this->hasMany(Hoteles_valoraciones::class,'id_hotel','id');
    }

    public function valoracion(){
      return Hoteles_valoraciones::all()->where('id_hotel',$this->id)->sum('calificacion');
    }

    public function promedio(){
        $comentarios = Hoteles_valoraciones::all()->where('id_hotel',$this->id)->count();

        if ($comentarios != 0) {
            $valoraciones = Hoteles_valoraciones::all()->where('id_hotel',$this->id)->sum('calificacion');
            $resultado = round(($valoraciones / $comentarios), 2);
            return $resultado;
        }else{
            return 0;
        }
    }

    public function precio_desde($id_moneda){
        $id = $this->id;

        $precio = Habitaciones_precios::orderBy('precio', 'ASC')->where('id_moneda',$id_moneda)->whereHas('habitacion',function($q) use ($id) {
                $q->where('id_hotel',$id);
        })->take(1)->first();

        if (is_null($precio->INGUAT)) {
            $precio->INGUAT=0;
        }

        if ($precio->oferta==0) {
            $precio->precio = $precio->precio;
        }else{
            $precio->precio = $precio->precio - (($precio->precio*$precio->oferta)/100);
        }

        return $precio->precio + (($precio->precio*$precio->IVA)/100) + (($precio->precio*$precio->ISR)/100) + (($precio->precio*$precio->INGUAT)/100);
    }

    public function servicios_principales(){

        $array = array();
        $data = array();
        $servicios = Hoteles_servicios::where('id_hotel',$this->id)->get();

        foreach ($servicios as $key) {
            
            if (is_null($key->servicio->img) && is_null($key->servicio->id_servicio)) {
                continue;
            }else{
                if (is_null($key->servicio->img)==false) {

                    array_push($data, $key->servicio->img);
                    array_push($data, $key->servicio->servicio);

                }else{
                    if (is_null($key->servicio->id_servicio)==false) {

                       if (is_null($key->servicio->principal_servicio->img)==false) {
                           if (in_array($key->servicio->id_servicio, $array)) {
                               continue;
                           }else{
                                array_push($array, $key->servicio->id_servicio);

                                array_push($data, $key->servicio->principal_servicio->img);
                                array_push($data, $key->servicio->principal_servicio->servicio);
                           }
                       }
                    }
                }
            }
        }
        return $data;  
    }

    public function servicios_principales_count(){

        $array = array();
        $i=0;
        $servicios = Hoteles_servicios::where('id_hotel',$this->id)->get();

        foreach ($servicios as $key) {
            
            if (is_null($key->servicio->img) && is_null($key->servicio->id_servicio)) {
                continue;
            }else{
                if (is_null($key->servicio->img)==false) {
                    $i++;
                }else{
                    if (is_null($key->servicio->id_servicio)==false) {
                       if (is_null($key->servicio->principal_servicio->img)==false) {
                           if (in_array($key->servicio->id_servicio, $array)) {
                               continue;
                           }else{
                            array_push($array, $key->servicio->id_servicio);
                            $i++;
                           }
                       }
                    }
                }
            }
        }
        return $i;           
    }

    public function servicios_establecimiento_principales(){

        $array = array();
        $data = array();
        $servicios = Hoteles_servicios::where('id_hotel',$this->id)->get();

        foreach ($servicios as $key) {
            
            if (is_null($key->servicio->id_servicio)) {
                continue;
            }else{                

                if (is_null($key->servicio->principal_servicio->img)==false) {

                    if (in_array($key->servicio->id_servicio, $array)) {
                        continue;
                    }else{
                        array_push($array, $key->servicio->id_servicio);


                        array_push($data, $key->servicio->principal_servicio->img);
                        array_push($data, $key->servicio->principal_servicio->servicio);
                        array_push($data, $key->servicio->id_servicio);
                    }
                }
                        
            }
        }

        return $data;  
    }

    public function subservicios_establecimiento($id_servicio){

        return Hoteles_servicios::where('id_hotel',$this->id)->whereHas('servicio',function($q) use ($id_servicio){
            $q->where('id_servicio',$id_servicio);
        })->get();        
    }

    public function otros_servicios_establecimiento(){

        return Hoteles_servicios::where('id_hotel',$this->id)->whereHas('servicio',function($q){
            $q->whereNotNull('img');
        })->get();   
    }

    public function check_disponibilidades($data){

        $disponibilidad = 0;

        if (is_null($this->edad_minima)==false) {
            if ($this->edad_minima > $data['edad_minima']) {
                return 'Este hotel posee restricciones de edad para la entrada';
            }
        }

        $habitaciones = $this->habitaciones->where('huesped','>=',$data['huesped']);

        if ($habitaciones->count() == 0) {
            return 'No hay habitaciones para la cantidad de huéspedes ingresada';
        }else{
            foreach ($habitaciones as $key) {
                if ($key->disponibilidad($data['check_in'],$data['check_out']) == 0) {
                    continue;
                }else{
                    $disponibilidad++;
                }
            }
        }

        if ($disponibilidad == 0) {
            return 'No hay habitaciones disponibles para la fecha solicitada';
        }else{
            return 'OK';
        }
    }
}
