<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Departamentos;
use Auth;

class DepartamentosController extends Controller
{
    public function index(){
    	$departamentos = Departamentos::all();
    	$i=1;
    	return view('admin.configuraciones.departamentos.index',compact('departamentos','i'));
    }

    public function edit($id){
    	$departamento = Departamentos::find($id);
    	return view('admin.configuraciones.departamentos.edit',compact('departamento'));
    }

    public function update($id,Request $request){
        $departamento = Departamentos::find($id);

        $file    = $request->file('foto');

        $code = generar_code(4);

        $name    = Auth::user()->id.'-'.$code.$file->getClientOriginalName();

        $path = \Storage::disk('departamentos')->put($name,  \File::get($file));

        $departamento->img = 'img/departamentos/'.$name;
        $departamento->save();

        return redirect()->back()->with('success','Actualizado')->with('mensaje','Foto del departamento actualizado con éxito');
    }

}
