@extends('admin.layouts.app')

@section('breadcrumb')
	<li class="breadcrumb-item"><a href="javascript:void(0);">Configuraciones</a></li>
    <li class="breadcrumb-item" aria-current="page"><a href="{{route('departamentos.index')}}">Departamentos</a></li>
    <li class="breadcrumb-item active" aria-current="page"><span>Actualizar</span></li>
@endsection

@section('css')
    <style type="text/css">
        #preview{
            text-align: center;
        }
    </style>
@endsection

@section('content')
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                        	
                            <center><h4>Actualizar departamento</h4></center>
                            <hr>

                            <form action="{{route('departamentos.update',$departamento->id)}}" method="post" 
                                enctype="multipart/form-data">
                                @csrf
                                
                                <div class="row">
                                    <div class="col">
                                        <h6>Departamento <strong class="text-danger">*</strong></h6>
                                        <input type="text" class="form-control" placeholder="Escriba la pregunta" value="{{$departamento->departamento}}" disabled="disabled"><br>
                                    </div>
                                </div>

                                <div class="row">
                                        <div class="col-md-6">
                                            <div class="imgPreview img-vista" id="preview">
                                                <img src="{{asset($departamento->img)}}">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <br>
                                            <div class="custom-file mt-5 mb-2" id="foto-div-0">
                                                <input type="file" class="custom-file-input" id="foto" name="foto" required="required" accept="image/x-png,image/jpeg" >
                                                <h6 class="custom-file-label" for="foto-0">Subir Foto <strong class="text-danger">*</strong></h6>
                                            </div>                                            
                                            <p style="text-align: justify; font-size: 18px;">
                                                
                                                <div class="ml-3">                        
                                                    Sube una imagen o fotografía en formato <strong>.JPG</strong> o <strong>.PNG.</strong><br> 
                                                    Max. 1MB
                                                    <br> 
                                                </div>                                         
                                            </p>
                                        </div>
                                    </div>
                                <div class="row">
                                    <div class="col">
                                        <button type="submit" class="btn btn-primary float-right">Actualizar</button>
                                    </div>
                                </div>
                            </form>                                         
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
     <script type="text/javascript">
            function fileValidation(){
                var fileInput = document.getElementById('foto');
                var filePath = fileInput.value;
                var allowedExtensions = /(.jpg|.jpeg|.png)$/i;
                if(!allowedExtensions.exec(filePath)){
                    return false;
                }else{
                    return true;     
                }
            }

            document.getElementById("foto").onchange = function (e) {
                // Creamos el objeto de la clase FileReader

                var validate = fileValidation();

                if (validate) {

                    let archivo = document.getElementById("foto");
                    let peso = archivo.files[0].size;
                    if(peso > 1000000) {
                            Snackbar.show({
                            text: 'Archivo muy pesado Tamaño máximo permitido es de 1MB',
                            pos: 'bottom-right',
                            actionText:"Ok"
                        }); 
                        $("#foto").val('');             
                    }else{
                        let reader = new FileReader();
                        reader.readAsDataURL(e.target.files[0]);
                        reader.onload = function () {
                            let preview = document.getElementById('preview'),
                                image = document.createElement('img');
                            image.src = reader.result;
                            preview.innerHTML = '';
                            preview.append(image);
                        };
                    }
                    
                }else{
                    var file = $('#foto').val();

                    if (file!='') {
                        Snackbar.show({
                            text: 'La extensión del icono no es válida, solo se permite extensiones .JPG o .PNG',
                            pos: 'bottom-right',
                            actionText:"Ok"
                        }); 
                    }            
                }
            }

            $('#foto').change(function () {

                var file = $('#foto').val();

                if (file == '') {
                    $('#preview').html('<img src="{{asset($departamento->img)}}">');
                }
            });
        </script> 
@endsection