<!DOCTYPE html>
<html lang="es">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <title>{{$titulo->data}}</title>

        <meta name="description" content="{{$descripcion->data}}"/>

        <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">
        <link rel="stylesheet" type="text/css" href="{{asset('css/theme.css')}}">
        <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css?family=Nunito:400,400i,600,600i,700,700i%7cPermanent+Marker" rel="stylesheet">
        <link rel="stylesheet" href="{{asset('css/fullscreen.css')}}">
        {!! NoCaptcha::renderJs() !!}
    </head>
    <body>
        @include('layouts.nav')
        

        @yield('content')

        
        @include('layouts.footer')

        <div class="modal fade" tabindex="-1" id="modal-huesped">
          <div class="modal-dialog modal-sm">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">Huésped</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <form action="#">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Adultos</h6>
                            <input type="number" name="a" class="form-control" min="0" required="required" id="huesped-a"
                                <?php if (isset($data_hoteles)) {
                                    echo "value='".$data_hoteles['a']."'";
                                }else{
                                    echo "value='1'";
                                } ?>
                            ><br>
                        </div>
                        <div class="col-md-6">
                            <h6>Niños</h6>
                            <input type="number" name="n" class="form-control" min="0" required="required"
                             id="huesped_n"
                                <?php if (isset($data_hoteles)) {
                                    echo "value='".$data_hoteles['n']."'";
                                }else{
                                    echo "value='0'";
                                } ?>
                             ><br>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="row" id="huesped-edad">
                            @if(isset($data_hoteles))
                                @if(is_array($data_hoteles['edad']))
                                    @foreach($data_hoteles['edad'] as $key)
                                          <div class="col-md-12">
                                            <h6>Edad del menor <strong class="text-danger">*</strong></h6>
                                              <select class="form-control edad-menor" name="edad[]" required="required">
                                                <option value="">Edad</option>
                                                @for($i=0;$i<=17;$i++)
                                                    <option value="{{$i}}"
                                                    <?php if ($key == $i) {
                                                        echo 'selected="selected"';
                                                    } ?>
                                                    >{{$i}}</option>
                                                @endfor
                                              </select><br>
                                           </div>
                                    @endforeach
                                @endif
                            @endif
                        </div>
                    </div>
                </form>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="huesped_guardar();">Guardar</button>
              </div>
            </div>
          </div>
        </div>

        <script type="text/javascript" src="{{asset('js/jquery-3.2.1.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/popper.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/bootstrap.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/prism.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/scrollMonitor.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/smooth-scroll.polyfills.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/zoom-vanilla.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/jquery.countdown.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/clipboard.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/jquery.smartWizard.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/flickity.pkgd.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/isotope.pkgd.min.js')}}"></script>
        <script type="text/javascript" src="{{asset('js/theme.js')}}"></script>
        <script src="{{asset('js/fullscreen.js')}}"></script>
        <script src="{{asset('js/buscador.js')}}"></script>

         @yield('script')
    </body>
</html>
