<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Habitaciones extends Model
{
    //
    public function precios () {
        return $this->hasMany(Habitaciones_precios::class, 'id_habitacion', 'id');
    }

    public function camas () {
        return $this->hasMany(Habitaciones_camas::class, 'id_habitacion', 'id');
    }
    
    public function equipamientos(){
    	return $this->hasMany(Habitaciones_equipamiento::class, 'id_habitacion', 'id');
    }

    public function equipamientos_tocador(){

        return Habitaciones_equipamiento::where('id_habitacion',$this->id)->whereHas('equipamiento',function($q){
            $q->where('tipo','tocador');
        })->get();
    }

    public function equipamientos_habitacion(){
        return Habitaciones_equipamiento::where('id_habitacion',$this->id)->whereHas('equipamiento',function($q){
            $q->where('tipo','habitacion');
        })->get();
    }

    public function imagenes(){
    	return $this->hasMany(Habitaciones_imagenes::class,'id_habitacion','id');
    }

    public function hotel(){
        return $this->belongsTo(Hoteles::class,'id_hotel','id');
    }

    #Precio

    public function precio($id_moneda){
        return Habitaciones_precios::where('id_habitacion',$this->id)->where('id_moneda',$id_moneda)->first();
    }

    public function precio_total($id_moneda){
        $id = $this->id;

        $precio = Habitaciones_precios::where('id_habitacion',$this->id)->where('id_moneda',$id_moneda)->first();

        if (is_null($precio->INGUAT)) {
            $precio->INGUAT=0;
        }

        if ($precio->oferta==0) {
            $precio->precio = $precio->precio;
        }else{
            $precio->precio = $precio->precio - (($precio->precio*$precio->oferta)/100);
        }

        return $precio->precio + (($precio->precio*$precio->IVA)/100) + (($precio->precio*$precio->ISR)/100) + (($precio->precio*$precio->INGUAT)/100);
    }

    public function precio_old($id_moneda){
        $id = $this->id;

        $precio = Habitaciones_precios::where('id_habitacion',$this->id)->where('id_moneda',$id_moneda)->first();

        if (is_null($precio->INGUAT)) {
            $precio->INGUAT=0;
        }

        return $precio->precio + (($precio->precio*$precio->IVA)/100) + (($precio->precio*$precio->ISR)/100) + (($precio->precio*$precio->INGUAT)/100);
    }

    public function precio_sin_impuesto($id_moneda){
        $id = $this->id;

        $precio = Habitaciones_precios::where('id_habitacion',$this->id)->where('id_moneda',$id_moneda)->first();

        if ($precio->oferta==0) {
            return $precio->precio;
        }else{
            return $precio->precio - (($precio->precio*$precio->oferta)/100);
        }
        
    }

    public function disponibilidad($check_in,$check_out){

        $reservadas = Disponibilidad::where('id_habitacion',$this->id)
        ->whereBetween('check_in',[$check_in,$check_out])
        ->orWhereBetween('check_out',[$check_in,$check_out])
        ->count();

        if (is_null($this->cantidad) || $this->cantidad=='') {
            $n = 0;
        }else{
            $n = $this->cantidad;
        }

        $disponible = $n - $reservadas;

        if ($disponible < 0) {
            $disponible = 0;
        }

        return $disponible;
    }
}
