<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hoteles;
use App\Habitaciones;
use App\Disponibilidad;
use Auth;

class DisponibilidadController extends Controller
{
    public function index(){
    	$hoteles = Hoteles::where('borrado','N')->where('publicado','S')->where('user_id',Auth::user()->id)->where('reclamar','N')->get();
    	return view('admin.disponibilidad.index',compact('hoteles'));
    }

    public function disponibilidad(Request $request){

    	$habitacion = Habitaciones::find($request->id);

    	if (is_null($habitacion)==false) {

    		if ($habitacion->id_hotel != $request->hotel) {
    			abort(404);
    			exit();
    		}

    		$num_habitacion = $habitacion->cantidad;

    		if ($num_habitacion=='' || is_null($num_habitacion)) {
    			$num_habitacion = 0;
    		}

    		$check_in =  new \Carbon\Carbon($request->check_in);
    		$check_out = new \Carbon\Carbon($request->check_out);

    		$reservadas = Disponibilidad::where('id_habitacion',$habitacion->id)
    		->whereBetween('check_in',[$request->check_in,$request->check_out])
    		->orWhereBetween('check_out',[$request->check_in,$request->check_out])
    		->count();

    		$disponible = $num_habitacion - $reservadas;

    		if ($disponible<0) {
    			$disponible = 0;
    		}

            $data = Disponibilidad::where('id_habitacion',$habitacion->id)->get();

    		return response()->json([
    			'disponible' => $disponible,
    			'data' => $data
    		]);
    	}else{
    		abort(404);
    	}    	
    }

    public function store(Request $request){

        $habitacion = Habitaciones::find($request->id);

        if (is_null($habitacion)==false) {

            if ($habitacion->id_hotel != $request->hotel) {
                abort(404);
                exit();
            }

            $num_habitacion = $habitacion->cantidad;

            if ($num_habitacion=='' || is_null($num_habitacion)) {
                $num_habitacion = 0;
            }       

            $reservadas = Disponibilidad::where('id_habitacion',$habitacion->id)
            ->whereBetween('check_in',[$request->check_in,$request->check_out])
            ->orWhereBetween('check_out',[$request->check_in,$request->check_out])
            ->count();

            $disponible = $num_habitacion - $reservadas;

            if ($disponible<0) {
                $disponible = 0;
            }

            if ($disponible<=0) {
                return 1;
            }else{
                $disponibilidad = new Disponibilidad();
                $disponibilidad->id_habitacion = $habitacion->id;
                $disponibilidad->check_in = $request->check_in;
                $disponibilidad->check_out = $request->check_out;
                $disponibilidad->save();
                return 0;
            }

        }else{
            abort(404);
        }   
    }

    public function eliminar(Request $request){
        $id = $request->id;
        $delete = Disponibilidad::find($id);

        if (is_null($delete)) {
            return 1;
        }else{
            $delete->delete();
            return 0;
        }
    }
}
