<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Preguntas;

class PreguntasController extends Controller
{
    public function index(){

    	$preguntas = Preguntas::all();
    	$i=1;
    	return view('admin.preguntas.index',compact('preguntas','i'));
    }

    public function create(){

    	return view('admin.preguntas.create');
    }


    public function store(Request $request){

    	$preguntas = new Preguntas();

    	$preguntas->pregunta = $request->pregunta;
    	$preguntas->respuesta = $request->respuesta;
    	$preguntas->save();

    	return redirect()->route('preguntas.index')->with('success','Registrado')->with('mensaje','Pregunta registrada con éxito');
    
    }


    public function edit($id){

    	$pregunta = Preguntas::find($id);

    	return view('admin.preguntas.edit',compact('pregunta'));
    }

    public function update($id, Request $request){

    	$preguntas = Preguntas::find($id);

    	$preguntas->pregunta  = $request->pregunta;
    	$preguntas->respuesta = $request->respuesta;
    	$preguntas->save();

    	return redirect()->route('preguntas.index')->with('success','Actualizado')->with('mensaje','Pregunta actualizada con éxito');    
    }

    public function delete($id){

    	$preguntas = Preguntas::find($id);
    	$preguntas->delete();

    	return redirect()->route('preguntas.index')->with('success','Eliminado')->with('mensaje','Pregunta eliminada con éxito');
    
    }
}
