@extends('admin.layouts.app')

@section('breadcrumb')
    <li class="breadcrumb-item" aria-current="page"><a href="{{route('servicios.index')}}">Servicios</a></li>
    <li class="breadcrumb-item active" aria-current="page"><span>Editar</span></li>
@endsection

@section('css')

@endsection

@section('content')
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                        	
                            <center><h4>Editar servicio</h4></center>
                            <hr>

                            <form action="{{route('servicios.update',$servicio->id)}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 mb-1">
                                        <center>
                                            <div id="preview" style="width: 100%;">
                                                <img 
                                                    @if(is_null($servicio->img))
                                                        src="{{asset('img/icon.svg')}}"
                                                    @else
                                                        src="{{asset($servicio->img)}}"
                                                    @endif

                                                >
                                            </div>
                                        </center>        
                                    </div>
                                    <div class="col-md-6">
                                        <label>Icono</label>
                                        <div class="custom-file">
                                          <input class="custom-file-input @error('foto') is-invalid @enderror" type="file" id="file-input" name="foto">
                                          <label class="custom-file-label" for="file-input">Subir icono...</label>
                                          @error('foto')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        </div>
                                        <p style="text-align: justify; font-size: 18px;">
                                            <br>
                                            Sube una icono en formato <strong>.SVG</strong> o <strong>.PNG.</strong> Dimensión recomendada <strong>24x24.</strong> <br>
                                            Max. <strong>100Kb</strong>
                                        </p>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col">
                                        <h6>Nombre del servicio <strong class="text-danger">*</strong></h6>
                                        <input type="text" name="servicio" value="{{$servicio->servicio}}" class="form-control  @if(session('error_servicio')) is-invalid @endif" placeholder=" Ej. WiFI">
                                        <div class="invalid-feedback">
                                               @if(session('error_servicio')) {{session('error_servicio')}} @endif
                                            </div>
                                       <br>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col">
                                        <button type="submit" class="btn btn-primary float-right">Actualizar</button>
                                    </div>
                                </div>
                            </form>                                         
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script type="text/javascript" src="{{asset('js/ckeditor/ckeditor.js')}}"></script>
    <script type="text/javascript">
        CKEDITOR.replace('respuesta');
    </script>
    <script type="text/javascript">
    function fileValidation(){
            var fileInput = document.getElementById('file-input');
            var filePath = fileInput.value;
            var allowedExtensions = /(.svg|.png)$/i;
            if(!allowedExtensions.exec(filePath)){
                return false;
            }else{
                return true;     
            }
        }

        document.getElementById("file-input").onchange = function (e) {
        // Creamos el objeto de la clase FileReader

        var validate = fileValidation();

        if (validate) {

            let archivo = document.getElementById("file-input");
            let peso = archivo.files[0].size;
            if(peso > 100000) {
                    Snackbar.show({
                    text: 'Archivo muy pesado Tamaño máximo permitido es de 100kb',
                    pos: 'bottom-right',
                    actionText:"Ok"
                }); 
                $("#file-input").val('');
             
            }else{
                let reader = new FileReader();
                reader.readAsDataURL(e.target.files[0]);
                reader.onload = function () {
                    let preview = document.getElementById('preview'),
                        image = document.createElement('img');
                    image.src = reader.result;
                    preview.innerHTML = '';
                    preview.append(image);
                };
            }

            
        }else{
            var file = $('#file-input').val();

            if (file!='') {
                Snackbar.show({
                    text: 'La extensión del icono no es válida, solo se permite extensiones .SVG o .PNG',
                    pos: 'bottom-right',
                    actionText:"Ok"
                }); 
            }            
        }
    }

    $('#file-input').change(function () {

        var file = $('#file-input').val();

        if (file == '') {
            $('#preview').html('<img src="/img/icon.svg">');
        }
    });
    </script>
@endsection