<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hoteles;
use App\Equipamiento;
use App\Tipos_camas;
use App\Habitaciones;
use App\Habitaciones_precios;
use App\Habitaciones_camas;
use App\Habitaciones_equipamiento;
use App\Habitaciones_imagenes;
use Auth;

class HabitacionesController extends Controller
{
    static function status($id){
        $count = Habitaciones::all()->where('id_hotel',$id)->where('publicado','S')->where('borrado','N')->count();

        if ($count==0) {
            $hotel = Hoteles::find($id);

            $hotel->publicado = 'N';
            $hotel->save();
        }

        return 0;
    }

    public function index($id){

    	$hotel = Hoteles::find($id);
    	$count = Habitaciones::all()->where('id_hotel',$id)->where('publicado','S')->where('borrado','N')->count();

        $total = Habitaciones::all()->where('id_hotel',$id)->where('borrado','N')->count();

        $habitaciones = Habitaciones::all()->where('id_hotel',$id)->where('borrado','N');

        $i = 1;

    	return view('admin.hoteles.habitaciones.index',compact('hotel','count','id','habitaciones','total','i'));
    }

    public function publicar_hotel($id, Request $request){

        $count = Habitaciones::all()->where('id_hotel',$id)->where('publicado','S')->where('borrado','N')->count();

        if ($count==0) {
            return redirect()->route('habitaciones.index',$id)->with('success','Error')->with('mensaje','Para poder publicar un hotel en la plataforma, debes de tener una habitación publicada');
        }else{

            if (Auth::user()->rol_id == 1) {
                $hotel = Hoteles::find($id);
            }else{
                $hotel = Hoteles::all()->where('id',$id)->where('user_id',Auth::user()->id)->first();
            }



            $hotel->publicado = $request->publicar;
            $hotel->save();

            return redirect()->route('habitaciones.index',$id)->with('success','Actualizado')->with('mensaje','Hotel actualizado con éxito');
        }
    }

    public function create($id){

    	$ser_tocador  = Equipamiento::all()->where('tipo','tocador');
    	$ser_habitacion = Equipamiento::all()->where('tipo','habitacion');
    	$tipos_camas = Tipos_camas::all();

    	return view('admin.hoteles.habitaciones.create',compact('ser_habitacion','ser_tocador','tipos_camas','id'));
    }

    public function store($id,Request $request){

        if (Auth::user()->rol_id == 1) {
            $hotel = Hoteles::find($id)->count();
        }else{
            $hotel = Hoteles::all()->where('borrado','N')->where('user_id',Auth::user()->id)->count();
        }

        if ($hotel>0) {
            
            $habitacion = new Habitaciones();
            $habitacion->id_hotel = $id;
            $habitacion->nombre = $request->nombre;
            $habitacion->cantidad = $request->cantidad;
            $habitacion->descripcion = $request->descripcion;
            $habitacion->publicado = $request->publicar;
            $habitacion->size = $request->size;
            
            #$huesped = ($request->cama_1 * 1) + ($request->cama_2 * 2) + ($request->cama_3 * 2) + ($request->cama_4 * 1);

            $huesped=$request->huesped;

            $habitacion->huesped = $huesped;
            $habitacion->save();

            if (is_null($request->iva_usd)) {
                $request->iva_usd = 0;
            }

            if (is_null($request->isr_usd)) {
                $request->isr_usd = 0;
            }

            $precio = new Habitaciones_precios();
            $precio->id_habitacion = $habitacion->id;
            $precio->id_moneda = 1;
            $precio->precio = $request->precio_usd;
            $precio->IVA = $request->iva_usd;
            $precio->ISR = $request->isr_usd;
            $precio->INGUAT = $request->inguat_usd;
            $precio->oferta = $request->oferta_usd;
            $precio->save();

            if (is_null($request->iva_q)) {
                $request->iva_q = 0;
            }

            if (is_null($request->isr_q)) {
                $request->isr_q = 0;
            }

            $precio = new Habitaciones_precios();
            $precio->id_habitacion = $habitacion->id;
            $precio->id_moneda = 2;
            $precio->precio = $request->precio_q;
            $precio->IVA = $request->iva_q;
            $precio->ISR = $request->isr_q;
            $precio->INGUAT = $request->inguat_q;
            $precio->oferta = $request->oferta_q;
            $precio->save();

            if (isset($request->servicios)) {

                foreach ($request->servicios as $key) {
                    $servicio = new Habitaciones_equipamiento();
                    $servicio->id_habitacion = $habitacion->id;
                    $servicio->id_equipo = $key;
                    $servicio->save();
                }
            }

            if (isset($request->foto)) {
                foreach ($request->foto as $key) {
                    if (is_null($key)) {
                        continue;
                    }else{
                        $foto = new Habitaciones_imagenes();
                        $foto->id_habitacion = $habitacion->id;
                        $foto->img = $key;
                        $foto->save();
                    }           
                }
            }

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 1;
            $cama->cantidad = $request->cama_1;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 2;
            $cama->cantidad = $request->cama_2;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 3;
            $cama->cantidad = $request->cama_3;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 4;
            $cama->cantidad = $request->cama_4;
            $cama->save();
        }        

        return redirect()->route('habitaciones.index',$id)->with('success','Registrado')->with('mensaje','Habitación registrada con éxito');
    }

    public function fotos(Request $request){

        $file    = $request->file('archivos');

        $code = generar_code(4);

        $name    = Auth::user()->id.'-'.$code.$file->getClientOriginalName();

        $path = \Storage::disk('habitaciones')->put($name,  \File::get($file));

        return 'img/hoteles/habitaciones/'.$name;
    }

    public function fotos_delete(Request $request){

        $n = strlen($request->img);
        $resultado = '';
        for ($i=0; $i <$n ; $i++) { 
            
            if ($i<25) {
               continue;
            }else{
                $resultado=$resultado.$request->img[$i];
            }
        }

        \Storage::disk('habitaciones')->delete($resultado);

        return $resultado;
    }

    public function edit($id,Request $request){

        $habitacion = Habitaciones::find($id);
        $ser_tocador  = Equipamiento::all()->where('tipo','tocador');
        $ser_habitacion = Equipamiento::all()->where('tipo','habitacion');
        $tipos_camas = Tipos_camas::all();

        $equipos = array();

        foreach ($habitacion->equipamientos as $key) {
            array_push($equipos, $key->id_equipo);
        }

        if (is_null($habitacion->precios[1]->oferta) or $habitacion->precios[1]->oferta==0) {

            $total = $habitacion->precios[1]->precio 
                + (($habitacion->precios[1]->precio * $habitacion->precios[1]->IVA)/100) 
                + (($habitacion->precios[1]->precio * $habitacion->precios[1]->ISR)/100);

            if (is_null($habitacion->precios[1]->INGUAT)) {
                # code...
            }else{
                $total = $total + (($habitacion->precios[1]->precio * $habitacion->precios[1]->INGUAT)/100);
            }

            $html_precio_q = '<h4>Q.'.$total.'</h4>';
        }else{

            $total = $habitacion->precios[1]->precio 
                + (($habitacion->precios[1]->precio * $habitacion->precios[1]->IVA)/100) 
                + (($habitacion->precios[1]->precio * $habitacion->precios[1]->ISR)/100);

            if (is_null($habitacion->precios[1]->INGUAT)) {
                # code...
            }else{
                $total = $total + (($habitacion->precios[1]->precio * $habitacion->precios[1]->INGUAT)/100);
            }

            $total_oferta = ($total - ($total* $habitacion->precios[1]->oferta)/100); 

            $html_precio_q = '<h4> <small class="mr-3"><strike>Q.'.$total.' </strike></small> Q'.$total_oferta.'</h4>';
        }

        if (is_null($habitacion->precios[0]->oferta) or $habitacion->precios[0]->oferta==0) {

            $total = $habitacion->precios[0]->precio 
                + (($habitacion->precios[0]->precio * $habitacion->precios[0]->IVA)/100) 
                + (($habitacion->precios[0]->precio * $habitacion->precios[0]->ISR)/100);

            if (is_null($habitacion->precios[0]->INGUAT)) {
                # code...
            }else{
                $total = $total + (($habitacion->precios[0]->precio * $habitacion->precios[0]->INGUAT)/100);
            }

            $html_precio_usd = '<h4>$.'.$total.'</h4>';
        }else{
            $total = $habitacion->precios[0]->precio 
                + (($habitacion->precios[0]->precio * $habitacion->precios[0]->IVA)/100) 
                + (($habitacion->precios[0]->precio * $habitacion->precios[0]->ISR)/100);

            if (is_null($habitacion->precios[0]->INGUAT)) {
                # code...
            }else{
                $total = $total + (($habitacion->precios[0]->precio * $habitacion->precios[0]->INGUAT)/100);
            }

            $total_oferta = ($total - ($total* $habitacion->precios[0]->oferta)/100); 

            $html_precio_usd = '<h4> <small class="mr-3"><strike>$.'.$total.' </strike></small> $'.$total_oferta.'</h4>';
        }
         
        
        return view('admin.hoteles.habitaciones.edit',compact('ser_habitacion','ser_tocador','tipos_camas','id','habitacion','equipos','html_precio_q','html_precio_usd'));
    }

    public function update($id,Request $request){

        $validar = 0;

        if ($validar==0) {
            
            $habitacion = Habitaciones::find($id);
            $habitacion->nombre = $request->nombre;
            $habitacion->cantidad = $request->cantidad;
            $habitacion->descripcion = $request->descripcion;
            $habitacion->publicado = $request->publicar;
            $habitacion->size = $request->size;

            #$huesped = ($request->cama_1 * 1) + ($request->cama_2 * 2) + ($request->cama_3 * 2) + ($request->cama_4 * 1);

            $huesped=$request->huesped;

            $habitacion->huesped = $huesped;
            $habitacion->save();

            foreach ($habitacion->precios as $key) {
                $precio = Habitaciones_precios::find($key->id);
                $precio->id_habitacion = $habitacion->id;     
                
                if (is_null($request->iva_usd)) {
                    $request->iva_usd = 0;
                }

                if (is_null($request->isr_usd)) {
                    $request->isr_usd = 0;
                }

                if ($key->id_moneda==1) {
                    $precio->precio = $request->precio_usd;
                    $precio->IVA = $request->iva_usd;
                    $precio->ISR = $request->isr_usd;
                    $precio->INGUAT = $request->inguat_usd;
                    $precio->oferta = $request->oferta_usd;
                }

                if (is_null($request->iva_q)) {
                    $request->iva_q = 0;
                }

                if (is_null($request->isr_q)) {
                    $request->isr_q = 0;
                }

                if ($key->id_moneda==2) {
                    $precio->precio = $request->precio_q;
                    $precio->IVA = $request->iva_q;
                    $precio->ISR = $request->isr_q;
                    $precio->INGUAT = $request->inguat_q;
                    $precio->oferta = $request->oferta_q;
                }

                $precio->save();
            }

            foreach ($habitacion->camas as $key) {
                $cama = Habitaciones_camas::find($key->id);

                if ($key->id_tipo_cama == 1) {
                    $cama->cantidad = $request->cama_1;
                }

                if ($key->id_tipo_cama == 2) {
                    $cama->cantidad = $request->cama_2;
                }

                if ($key->id_tipo_cama == 3) {
                    $cama->cantidad = $request->cama_3;
                }

                if ($key->id_tipo_cama == 4) {
                    $cama->cantidad = $request->cama_4;
                }
                
                $cama->save();
            }

            $servicios_old = array();
            foreach ($habitacion->equipamientos as $key) {
                array_push($servicios_old, $key->id_equipo);
            }

            

            if (isset($request->servicios)) {



                $servicios_update = $request->servicios;                
                $equipos  = Equipamiento::all();

                foreach ($equipos as $key) {
                    
                    if (in_array($key->id, $servicios_old)) {
                        
                        if (in_array($key->id, $servicios_update)) {
                            continue;
                        }else{
                            $delete = Habitaciones_equipamiento::where('id_habitacion',$id)->where('id_equipo',$key->id)->first();
                            $delete->delete();
                        }
                    }else{

                        if (in_array($key->id, $servicios_update)) {
                            $nuevo = new Habitaciones_equipamiento();
                            $nuevo->id_habitacion = $habitacion->id;
                            $nuevo->id_equipo = $key->id;
                            $nuevo->save();
                        }else{
                            continue;
                        }
                    }

                }
                
            }else{
                $delete = Habitaciones_equipamiento::where('id_habitacion',$id);

                if ($delete->count()>0) {
                    $delete->delete();
                }
            }


            if (isset($request->id_img)) {

                foreach ($request->id_img as $key) {
                    
                    $delete = Habitaciones_imagenes::find($key);

                    if (is_null($delete)==false) {
                        $n = strlen($delete->img);
                        $resultado = '';
                        for ($i=0; $i <$n ; $i++) { 
                            
                            if ($i<25) {
                               continue;
                            }else{
                                $resultado=$resultado.$delete->img[$i];
                            }
                        }

                        \Storage::disk('habitaciones')->delete($resultado);

                        $delete->delete();
                    }
                }
            }

            // Si hay fotos nuevas
            if (isset($request->foto)) {
                foreach ($request->foto as $key) {
                    if (is_null($key)) {
                        continue;
                    }else{
                        $foto = new Habitaciones_imagenes();
                        $foto->id_habitacion = $habitacion->id;
                        $foto->img = $key;
                        $foto->save();
                    }           
                }
            }
            
        }        
        $this->status($habitacion->id_hotel);
        return redirect()->route('habitaciones.index',$habitacion->id_hotel)->with('success','Actualizado')->with('mensaje','Habitación actualizada con éxito');
    }

    public function delete($id){
        $hotel = Habitaciones::find($id);
        $hotel->borrado = 'S';
        $hotel->save();
        $this->status($hotel->id_hotel);

        return redirect()->route('habitaciones.index',$id)->with('success','Eliminado')->with('mensaje','Habitación eliminada con éxito');
    }
}
