<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Hoteles;
use App\Categorias;
use App\Departamentos;
use App\Servicios;
use App\Empresas;
use App\Hoteles_ubicaciones;
use App\Hoteles_servicios;
use App\Hoteles_recomendaciones;
use App\Hoteles_contactos;
use App\Hoteles_imagenes;
use App\Hoteles_tarjetas;
use App\Tarjetas;
use Auth;


use Intervention\Image\ImageManagerStatic as Image;
use App\Imports\HotelesImport;
use Maatwebsite\Excel\Facades\Excel;

class HotelesController extends Controller
{
    public function index(){
    	$hoteles = Hoteles::all()->where('borrado','N');
        $i=1;
        $titulo = "Todos los hoteles";
    	return view('admin.hoteles.index',compact('hoteles','i','titulo'));
    }

    public function hoteles_reclamar(){
        $hoteles = Hoteles::all()->where('borrado','N')->where('reclamar','S');
        $i=1;
        $titulo = "Hoteles por reclamar";
        return view('admin.hoteles.index',compact('hoteles','i','titulo'));
    }

    public function mis_hoteles(){
        $hoteles = Hoteles::all()->where('borrado','N')->where('reclamar','N')->where('user_id',Auth::user()->id);
        $i=1;
        $titulo = "Mis Hoteles";
        return view('admin.hoteles.index',compact('hoteles','i','titulo'));
    }

    public function create(){
    	$categorias = Categorias::all();
    	$departamentos = Departamentos::all();
    	$servicios = Servicios::all();
        $empresas = Empresas::all();
        $tarjetas = Tarjetas::all();
    	return view('admin.hoteles.create',compact('categorias','departamentos','servicios','empresas','tarjetas'));
    }

    public function store(Request $request){

        $hoteles = new Hoteles();
        $hoteles->url   = preparar_url($request->nombre);
        $hoteles->nombre = $request->nombre;
        $hoteles->user_id = Auth::user()->id;
        $hoteles->id_categoria = $request->categoria;
        $hoteles->edad_minima_registro_entrada = $request->edad_checkin;
        $hoteles->web = $request->web;
        $hoteles->video = $request->video;
        $hoteles->cunas = $request->cunas;

        $hoteles->entrada_desde = $request->entrada_desde;
        $hoteles->entrada_hasta = $request->entrada_hasta;
        $hoteles->salida = $request->salida;

        //guardar logo

        if ($request->file('logo')) {
            $name = str_replace(' ', '_', $request->nombre);
            $extensionLogo = $request->file('logo')->getClientOriginalExtension();
            $nameLogo = "{$name}.{$extensionLogo}";
            $imagen = Image::make($request->file('logo'))->resize(140,120)
            ->encode($extensionLogo);
            \Storage::disk('logos')->put($nameLogo, $imagen);
            $hoteles->logo = "img/logos/{$nameLogo}";
        }
        //fin
        $hoteles->estrellas = $request->estrellas;
        $hoteles->informacion_importante = $request->informacion_importante;
        $hoteles->aviso_importante = $request->aviso_importante;
        $hoteles->descripcion = $request->descripcion;
        $hoteles->descripcion_corta = $request->descripcion_corta;

        if (Auth::user()->rol_id==1) {
            $hoteles->reclamar = $request->reclamar;
        }else{
            $hoteles->reclamar = 'N';
        }
        
        $hoteles->publicado = 'N';
       
        if (is_null($request->mascota)) {
            $hoteles->mascotas = 'N';
        }else{
            $hoteles->mascotas = $request->mascota;
        }

        if (isset($request->mascota_costo)) {
            $hoteles->mascotas_costo_adicional = $request->mascota_costo;                 
        }else{
            $hoteles->mascotas_costo_adicional = 'N';                
        }

        $hoteles->edad_minima = $request->edad_minima;
        $hoteles->save();

        $hoteles->url = $hoteles->url.'-'.$hoteles->id;
        $hoteles->save();

        $ubicaciones = new Hoteles_ubicaciones();
        $ubicaciones->id_hotel = $hoteles->id;
        $ubicaciones->id_departamento = $request->departamento;
        $ubicaciones->id_municipio = $request->municipio;
        $ubicaciones->latitud = $request->latitud;
        $ubicaciones->longitud = $request->longitud;
        $ubicaciones->direccion = $request->direccion;
        $ubicaciones->save();

        if (isset($request->servicios)) {

            foreach ($request->servicios as $key) {
                $servicio = new Hoteles_servicios();
                $servicio->id_hotel = $hoteles->id;
                $servicio->id_servicio = $key;
                $servicio->save();
            }
        }

        if (isset($request->tarjetas)) {

            foreach ($request->tarjetas as $key) {
                $tarjetas = new Hoteles_tarjetas();
                $tarjetas->id_hotel = $hoteles->id;
                $tarjetas->id_tarjeta = $key;
                $tarjetas->save();
            }
        }


        if (isset($request->foto)) {
            foreach ($request->foto as $key) {
                if (is_null($key)) {
                    continue;
                }else{
                    $foto = new Hoteles_imagenes();
                    $foto->id_hotel = $hoteles->id;
                    $foto->img = $key;
                    $foto->save();
                }           
            }
        }

        if (isset($request->empresa)) {

            foreach ($request->empresa as $key) {
                $recomendaciones = new Hoteles_recomendaciones();
                $recomendaciones->id_hotel = $hoteles->id;
                $recomendaciones->id_empresa = $key;

                if (Auth::user()->rol_id == 1) {
                    $recomendaciones->aprobacion = 'S';
                }else{
                    $recomendaciones->aprobacion = 'N';
                }

                $recomendaciones->save();
            }

        }

        for ($i=0; $i <$request->total ; $i++) { 
            
            $contacto = new Hoteles_contactos();
            $contacto->id_hotel = $hoteles->id;
            $contacto->telefono = $request->telefono[$i];
            $contacto->email = $request->email[$i];
            $contacto->save();
        }


        return redirect()->route('habitaciones.index',$hoteles->id)->with('success','Registrado')->with('mensaje','Hotel registrado con éxito');
    }

    public function import(){
        set_time_limit(100000);
        //Excel::import(new HotelesImport, 'data.xlsx');

        $hoteles = Hoteles::all();

        /*foreach ($hoteles as $key) {
            
            $url = preparar_url($key->nombre);
            $url = $url.'-'.$key->id;

            $hotel = Hoteles::find($key->id);
            $hotel->url = $url;
            $hotel->save();
        }*/

       
        
        foreach ($hoteles as $key) {
             $tarjetas = Tarjetas::all();
            foreach ($tarjetas as $key2) {
                $tarjetas = new Hoteles_tarjetas();
                $tarjetas->id_hotel = $key->id;
                $tarjetas->id_tarjeta = $key2->id;
                $tarjetas->save();
            }
        }

        return 0;
    }

    public function fotos(Request $request){

        $file    = $request->file('archivos');

        $code = generar_code(4);

        $name    = Auth::user()->id.'-'.$code.$file->getClientOriginalName();

        $path = \Storage::disk('hoteles')->put($name,  \File::get($file));

        return 'img/hoteles/'.$name;
    }

    public function fotos_delete(Request $request){

        $n = strlen($request->img);
        $resultado = '';
        for ($i=0; $i <$n ; $i++) { 
            
            if ($i<12) {
               continue;
            }else{
                $resultado=$resultado.$request->img[$i];
            }
        }

        \Storage::disk('hoteles')->delete($resultado);

        return $resultado;
    }


    public function edit($id){
        $categorias = Categorias::all();
        $departamentos = Departamentos::all();
        $servicios = Servicios::all();
        $empresas = Empresas::all();
        $tarjetas = Tarjetas::all();
        $hotel = Hoteles::find($id);

        $servicios_hotel = array();

        foreach ($hotel->servicios as $key) {
            array_push($servicios_hotel, $key->id_servicio);
        }

        $tarjetas_hotel = array();

        foreach ($hotel->tarjetas as $key) {
            array_push($tarjetas_hotel, $key->id_tarjeta);
        }

        $recomendaciones_hotel = array();

        foreach ($hotel->recomendaciones as $key) {
            array_push($recomendaciones_hotel, $key->id_empresa);
        }

        return view('admin.hoteles.edit',compact('categorias','departamentos','servicios','empresas','tarjetas','hotel','servicios_hotel','tarjetas_hotel','recomendaciones_hotel'));
    }

    public function update($id,Request $request){
       // dd($request->all());
        $validar = 0;

        if ($validar==0) {
            
            $hotel = Hoteles::find($id);
            $hotel->nombre = $request->nombre;
            $hotel->id_categoria = $request->categoria;
            $hotel->web = $request->web;
            $hotel->estrellas = $request->estrellas;
            $hotel->descripcion = $request->descripcion;
            
            if (Auth::user()->rol_id==1) {
                $hotel->reclamar = $request->reclamar;
            }else{
                $hotel->reclamar = 'N';
            }
            //eliminar logo
            if ($request->id_logo) {
                $archivoExplode = explode('/',$request->id_logo);
       
                \Storage::disk('logos')->delete($archivoExplode[2]);
                $hotel->logo = null;
            }
            //
            //guardar logo
            if ($request->file('logo')) {
                $name = str_replace(' ', '_', $request->nombre);
                $extensionLogo = $request->file('logo')->getClientOriginalExtension();
                $nameLogo = "{$name}.{$extensionLogo}";
                $imagen = Image::make($request->file('logo'))->resize(140,120)
                ->encode($extensionLogo);
                \Storage::disk('logos')->put($nameLogo, $imagen);
                $hotel->logo = "img/logos/{$nameLogo}";
            }
            //fin
            $hotel->edad_minima_registro_entrada = $request->edad_checkin;
            $hotel->video = $request->video;
            $hotel->cunas = $request->cunas;

            $hotel->entrada_desde = $request->entrada_desde;
            $hotel->entrada_hasta = $request->entrada_hasta;
            $hotel->salida = $request->salida;

            $hotel->informacion_importante = $request->informacion_importante;
            $hotel->aviso_importante = $request->aviso_importante;
            $hotel->descripcion_corta = $request->descripcion_corta;

            if (is_null($request->mascota)) {
                $hotel->mascotas = 'N';
            }else{
                $hotel->mascotas = $request->mascota;
            }

            if (isset($request->mascota_costo)) {
                $hotel->mascotas_costo_adicional = $request->mascota_costo;                 
            }else{
                $hotel->mascotas_costo_adicional = 'N';                
            }

            $hotel->edad_minima = $request->edad_minima;
            $hotel->save();

            $ubicaciones = Hoteles_ubicaciones::where('id_hotel',$hotel->id)->first();
            $ubicaciones->id_departamento = $request->departamento;
            $ubicaciones->id_municipio = $request->municipio;
            $ubicaciones->latitud = $request->latitud;
            $ubicaciones->longitud = $request->longitud;
            $ubicaciones->direccion = $request->direccion;
            $ubicaciones->save();

            //Servicios

            $servicios_old = array();
            foreach ($hotel->servicios as $key) {
                array_push($servicios_old, $key->id_servicio);
            }

            if (isset($request->servicios)) {

                $servicios_update = $request->servicios;                
                $servicios  = Servicios::all();

                foreach ($servicios as $key) {
                    
                    if (in_array($key->id, $servicios_old)) {
                        
                        if (in_array($key->id, $servicios_update)) {
                            continue;
                        }else{
                            $delete = Hoteles_servicios::where('id_hotel',$id)->where('id_servicio',$key->id)->first();
                            $delete->delete();
                        }
                    }else{

                        if (in_array($key->id, $servicios_update)) {
                            $nuevo = new Hoteles_servicios();
                            $nuevo->id_hotel = $hotel->id;
                            $nuevo->id_servicio = $key->id;
                            $nuevo->save();
                        }else{
                            continue;
                        }
                    }

                }
                
            }else{
                $delete = Hoteles_servicios::where('id_hotel',$id);

                if ($delete->count()>0) {
                    $delete->delete();
                }
            }


            //Tarjetas

            $tarjetas_old = array();
            foreach ($hotel->tarjetas as $key) {
                array_push($tarjetas_old, $key->id_tarjeta);
            }

            if (isset($request->tarjetas)) {

                $tarjetas_update = $request->tarjetas;                
                $tarjetas  = Tarjetas::all();

                foreach ($tarjetas as $key) {
                    
                    if (in_array($key->id, $tarjetas_old)) {
                        
                        if (in_array($key->id, $tarjetas_update)) {
                            continue;
                        }else{
                            $delete = Hoteles_tarjetas::where('id_hotel',$id)->where('id_tarjeta',$key->id)->first();
                            $delete->delete();
                            continue;
                        }
                    }else{

                        if (in_array($key->id, $tarjetas_update)) {
                            $nuevo = new Hoteles_tarjetas();
                            $nuevo->id_hotel = $hotel->id;
                            $nuevo->id_tarjeta = $key->id;
                            $nuevo->save();
                        }else{
                            continue;
                        }
                    }

                }
                
            }else{
                $delete = Hoteles_tarjetas::where('id_hotel',$id);

                if ($delete->count()>0) {
                    $delete->delete();
                }
            }

            //Empresas

            $empresas_old = array();
            foreach ($hotel->recomendaciones as $key) {
                array_push($empresas_old, $key->id_empresa);
            }

            if (isset($request->empresa)) {


                $empresas_update = $request->empresa;                
                $empresas  = Empresas::all();

                foreach ($empresas as $key) {


                    
                    if (in_array($key->id, $empresas_old)) {
                        
                        if (in_array($key->id, $empresas_update)) {
                            continue;
                        }else{
                            $delete = Hoteles_recomendaciones::where('id_hotel',$id)->where('id_empresa',$key->id)->first();
                            $delete->delete();
                        }
                    }else{

                        if (in_array($key->id, $empresas_update)) {
                            $nuevo = new Hoteles_recomendaciones();
                            $nuevo->id_hotel = $hotel->id;
                            $nuevo->id_empresa = $key->id;
                            $nuevo->save();
                        }else{
                            continue;
                        }

                    }

                }
                
            }else{
                $delete = Hoteles_recomendaciones::where('id_hotel',$id);

                if ($delete->count()>0) {
                    $delete->delete();
                }
            }

            if (isset($request->id_img)) {

                foreach ($request->id_img as $key) {
                    
                    $delete = Hoteles_imagenes::find($key);

                    if (is_null($delete)==false) {

                        $n = strlen($delete->img);

                        $resultado = '';

                        for ($i=0; $i <$n ; $i++) {                             
                            if ($i<12) {
                               continue;
                            }else{
                                $resultado=$resultado.$delete->img[$i];
                            }
                        }

                        \Storage::disk('hoteles')->delete($resultado);

                        $delete->delete();
                    }
                }
            }

            // Si hay fotos nuevas
            if (isset($request->foto)) {
                foreach ($request->foto as $key) {
                    if (is_null($key)) {
                        continue;
                    }else{
                        $foto = new Hoteles_imagenes();
                        $foto->id_hotel = $hotel->id;
                        $foto->img = $key;
                        $foto->save();
                    }           
                }
            }
        }

        $data_update = 0;

        for ($i=0; $i <$request->total ; $i++) { 
            
            if ($i==0) {

                $id = $hotel->contactos[0]->id;
                $contacto = Hoteles_contactos::find($id);
                $contacto->telefono = $request->telefono[$i];
                $contacto->email = $request->email[$i];
                $contacto->save();
                continue;
            }

            if ($data_update==0 && isset($request->db_id)) {

                foreach ($request->db_id as $key) {

                    if (is_null($request->email[$i]) && is_null($request->telefono[$i])) {
                        $contacto = Hoteles_contactos::find($key);
                        if ($contacto->count()>0) {
                            $contacto->delete();
                        }                        
                    }else{
                        $contacto = Hoteles_contactos::find($key);
                        $contacto->telefono = $request->telefono[$i];
                        $contacto->email = $request->email[$i];
                        $contacto->save();
                    }

                    $i++;
                }

                $data_update=1;

                if ($i == $request->total) {
                    break;
                }
            }

            $contacto = new Hoteles_contactos();
            $contacto->id_hotel = $hotel->id;
            $contacto->telefono = $request->telefono[$i];
            $contacto->email = $request->email[$i];
            $contacto->save();
        }


        if (Auth::user()->rol_id!=1) {
            return redirect()->route('hoteles.propios')->with('success','Actualizado')->with('mensaje','Hotel actualizado con éxito');
            exit();
        }

        return redirect()->route('hoteles.index')->with('success','Actualizado')->with('mensaje','Hotel actualizado con éxito');
    }

    public function delete($id){

        $hotel = Hoteles::find($id);
        $hotel->borrado = 'S';
        $hotel->save();

        return redirect()->route('hoteles.index')->with('success','Eliminado')->with('mensaje','Hotel eliminado con éxito');
    }
}
