<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ServiciosRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'foto'      => 'required',
            'servicio'  => 'required|min:6',
        ];

        return $rules;
    }
      public function messages()
    {
        return [

            'foto.required'         => 'La foto es requerida',
            'servicio.required'     => 'El nombre del servicio es requerido',
            'servicio.min'          => 'El nombre del servicio debe contener minimo 6 caracteres'

        ];
    }
}
