<?php
namespace App\Imports;

use App\Hoteles;
use App\Hoteles_recomendaciones;
use App\Hoteles_ubicaciones;

use Maatwebsite\Excel\Concerns\ToModel;

use App\Departamentos;
use App\Municipios;
use App\Categorias;

use App\Hoteles_tarjetas;
use App\Tarjetas;
use App\Hoteles_contactos;

use App\Habitaciones;
use App\Habitaciones_precios;
use App\Habitaciones_camas;

class HotelesImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */

    public function departamento($name){
        $departamento = Departamentos::where('departamento','LIKE','%'.$name.'%')->first();
        return $departamento->id;
    }

    public function municipio($name,$id_departamento){

        $municipio = Municipios::where('id_departamento',$id_departamento)
        ->where('municipio','LIKE','%'.$name.'%')
        ->first();

        if (is_null($municipio)) {

            if ($id_departamento==1 && $name == 'SANTA CATALINA LA TINTA') {
                return 5;
            }else{
                dd($name);
                dd($id_departamento);

                exit();
            }            
        }
        return $municipio->id;
    }

    public function categorias($name){
        $categorias = Categorias::where('categoria','LIKE', '%'.$name.'%')->first();

        if (is_null($categorias)) {
            return 1;
        }else{
            return $categorias->id;
        }
    }

    public function estrellas($name){
        $name = intval(preg_replace('/[^0-9]+/', '', $name), 10);
        if ($name=='') {
            return 0;
        }else{
            if ($name>5) {
                return 5;
            }else{
                return $name;
            }
        }
    }

    public function contacto(array $row){

        return [
            'email' => [0,1,2,3],
            'telefono' => [0,1,2,3]
        ];
    }

    public function precio($name){

    }

    public function model(array $row)
    {
        set_time_limit(100000);

        if ($row[0]=='DEPARTAMENTO') {
            
        }else{        

            $hoteles = new Hoteles();

            $hoteles->nombre = $row[2];
            $hoteles->url = '------';
            $hoteles->user_id = 1;
            $hoteles->id_categoria = $this->categorias($row[9]);
            $hoteles->edad_minima_registro_entrada = 18;
            $hoteles->web = $row[7];
            $hoteles->cunas = 'N';

            $hoteles->entrada_desde = date('15:00:00');
            $hoteles->entrada_hasta = date('00:00:00');
            $hoteles->salida = date('12:00:00'); 
            $hoteles->reclamar = 'N';

            $hoteles->estrellas = $this->estrellas($row[10]) + 1;            
            $hoteles->publicado = 'S';
            $hoteles->mascotas = 'N';
            $hoteles->mascotas_costo_adicional = 'N'; 
            $hoteles->informacion_importante = 'Próximamente aquí';
            $hoteles->aviso_importante = 'Próximamente aquí';
            $hoteles->descripcion = 'Próximamente aquí';
            $hoteles->descripcion_corta = 'Próximamente aquí';
            $hoteles->save();

            $recomendaciones = new Hoteles_recomendaciones();
            $recomendaciones->id_hotel = $hoteles->id;
            $recomendaciones->id_empresa = 2;
            $recomendaciones->aprobacion = 'S';
            $recomendaciones->save();       

            $ubicaciones = new Hoteles_ubicaciones();
            $ubicaciones->id_hotel = $hoteles->id;
            $ubicaciones->id_departamento = $this->departamento($row[0]);
            $ubicaciones->id_municipio = $this->municipio($row[1],$ubicaciones->id_departamento);
            $ubicaciones->latitud = '15.7834711';
            $ubicaciones->longitud = '-90.2307587';
            $ubicaciones->save();  


            $email    = $row[6]; 
            $telefono = $row[4];

            $email_data = '';
            $telefono_data= '';

            for ($i=0; $i<strlen($email); $i++) { 

                if ($email[$i]==',' || $email[$i]==';' || $email[$i]=='/') {
                    break;
                }else{
                    $email_data = $email_data.$email[$i];
                }                
            }

            for ($i=0; $i <strlen($telefono) ; $i++) { 
                
                if ($telefono[$i]==',' || $telefono[$i]==';' || $telefono[$i]=='/') {
                    break;
                }else{
                    $telefono_data = $telefono_data.$telefono[$i];
                }                
            }

            $telefono_data = intval(preg_replace('/[^0-9]+/', '', $telefono_data));
            

            $contacto = new Hoteles_contactos();
            $contacto->id_hotel = $hoteles->id;
            $contacto->telefono = $telefono_data;
            $contacto->email = $email_data;
            $contacto->save();

            $habitacion = new Habitaciones();
            $habitacion->id_hotel = $hoteles->id;
            $habitacion->nombre = 'Habitación sencilla';
            $habitacion->cantidad = 10;
            $habitacion->publicado = 'S';
            $habitacion->size = 35;
            $habitacion->huesped = 1;
            $habitacion->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 1;
            $cama->cantidad = 1;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 2;
            $cama->cantidad = 0;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 3;
            $cama->cantidad = 0;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 4;
            $cama->cantidad = 0;
            $cama->save();

            $money = $row[11];
            $money_data='';
            $dolar = 0;
            for ($i=0; $i <strlen($money) ; $i++) { 

                if ($i==0) {
                    if ($money[0]=='Q') {
                        $dolar=0;
                        continue;
                    }else{
                        $dolar=1;

                        if ($money[0]=='$') {
                            continue;
                        }
                    }
                }
                
                if ($money[$i]==';' || $money[$i]=='/' || $money[$i]==' ' || $money[$i]=='$' || $money[$i]=='Q') {
                    break;
                }else{
                    $money_data = $money_data.$money[$i];
                }                
            }

            $money_data = intval(preg_replace('/[^0-9]+/', '', $money_data));

            if ($dolar==1) {
                # 7.78

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 2;
                $precio->precio = ($money_data * 7.78);
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 1;
                $precio->precio = $money_data;
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();
            }else{
                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 2;
                $precio->precio = $money_data;
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 1;
                $precio->precio = ($money_data/7.78);
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();
            }


            $habitacion = new Habitaciones();
            $habitacion->id_hotel = $hoteles->id;
            $habitacion->nombre = 'Habitación doble';
            $habitacion->cantidad = 10;
            $habitacion->publicado = 'S';
            $habitacion->size = 35;
            $habitacion->huesped = 2;
            $habitacion->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 1;
            $cama->cantidad = 0;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 2;
            $cama->cantidad = 1;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 3;
            $cama->cantidad = 0;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 4;
            $cama->cantidad = 0;
            $cama->save();

            $money = $row[12];
            $money_data='';
            $dolar = 0;
            for ($i=0; $i <strlen($money) ; $i++) { 

                if ($i==0) {
                    if ($money[0]=='Q') {
                        $dolar=0;
                        continue;
                    }else{
                        $dolar=1;

                        if ($money[0]=='$') {
                            continue;
                        }
                    }
                }
                
                if ($money[$i]==';' || $money[$i]=='/' || $money[$i]==' ' || $money[$i]=='$' || $money[$i]=='Q') {
                    break;
                }else{
                    $money_data = $money_data.$money[$i];
                }                
            }

            $money_data = intval(preg_replace('/[^0-9]+/', '', $money_data));
            if ($dolar==1) {
                # 7.78

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 2;
                $precio->precio = ($money_data * 7.78);
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 1;
                $precio->precio = $money_data;
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();
            }else{
                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 2;
                $precio->precio = $money_data;
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 1;
                $precio->precio = ($money_data/7.78);
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();
            }

            $habitacion = new Habitaciones();
            $habitacion->id_hotel = $hoteles->id;
            $habitacion->nombre = 'Habitación triple';
            $habitacion->cantidad = 10;
            $habitacion->publicado = 'S';
            $habitacion->size = 35;
            $habitacion->huesped = 3;
            $habitacion->save();
            
            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 1;
            $cama->cantidad = 1;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 2;
            $cama->cantidad = 1;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 3;
            $cama->cantidad = 0;
            $cama->save();

            $cama = new Habitaciones_camas();
            $cama->id_habitacion = $habitacion->id;
            $cama->id_tipo_cama = 4;
            $cama->cantidad = 0;
            $cama->save();

            $money = $row[13];
            $money_data='';
            $dolar = 0;
            for ($i=0; $i <strlen($money) ; $i++) { 

                if ($i==0) {
                    if ($money[0]=='Q') {
                        $dolar=0;
                        continue;
                    }else{
                        $dolar=1;

                        if ($money[0]=='$') {
                            continue;
                        }
                    }
                }
                
                if ($money[$i]==';' || $money[$i]=='/' || $money[$i]==' ' || $money[$i]=='$' || $money[$i]=='Q' || $money[$i]==',') {
                    break;
                }else{
                    $money_data = $money_data.$money[$i];
                }                
            }

            $money_data = intval(preg_replace('/[^0-9]+/', '', $money_data));
            if ($dolar==1) {
                # 7.78

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 2;
                $precio->precio = ($money_data * 7.78);
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 1;
                $precio->precio = $money_data;
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();
            }else{
                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 2;
                $precio->precio = $money_data;
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();

                $precio = new Habitaciones_precios();
                $precio->id_habitacion = $habitacion->id;
                $precio->id_moneda = 1;
                $precio->precio = ($money_data/7.78);
                $precio->IVA = 0;
                $precio->ISR = 0;
                $precio->INGUAT = 0;
                $precio->oferta = 0;
                $precio->save();
            }

        }

    }
}
