<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHotelesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hoteles', function (Blueprint $table) {
            $table->id();
            $table->string('url',500);
            $table->string('nombre',255);

            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->unsignedBigInteger('id_categoria');
            $table->foreign('id_categoria')->references('id')->on('categorias')->onDelete('cascade');

            $table->string('web',180)->nullable();
            $table->string('video',380)->nullable();

            $table->enum('estrellas',[0,1,2,3,4,5]);
            $table->time('entrada_desde',0);
            $table->time('entrada_hasta',0);
            $table->integer('edad_minima_registro_entrada');
            $table->time('salida',0);
            $table->enum('cunas',['S','N']);

            $table->string('descripcion_corta',500)->nullable();
            $table->text('informacion_importante')->nullable();
            $table->text('aviso_importante')->nullable();
            $table->text('descripcion')->nullable();


            $table->enum('mascotas',['S','N'])->default('N');
            $table->enum('mascotas_costo_adicional',['S','N'])->default('N');
            $table->integer('edad_minima')->nullable();
            $table->enum('reclamar',['S','N']);
            $table->enum('publicado',['S','N']);
            $table->enum('borrado',['S','N'])->default('N');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hoteles');
    }
}
