@extends('admin.layouts.app')

@section('breadcrumb')
	<li class="breadcrumb-item"><a href="javascript:void(0);">Cuenta</a></li>
    <li class="breadcrumb-item active" aria-current="page"><span>Información personal</span></li>
@endsection

@section('css')

@endsection

@section('content')
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                        	
                            <center><h4>Actualizar información</h4></center>
                            <hr>

                            <form action="{{route('cuenta.update')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                
                                <div class="container">
                                  <div class="rounded-lg p-4 mb-4">
                                    <div class="media align-items-center">
                                        <div id="preview">
                                          <img src="{{asset(Auth::user()->img)}}" width="90" alt="{{Auth::user()->name}}">
                                        </div>
                                      <div class="media-body pl-3">
                                        <div class="custom-file">
                                          <input class="custom-file-input @error('foto') is-invalid @enderror" type="file" id="file-input" name="foto" accept="image/x-png,image/jpeg">
                                          <label class="custom-file-label" id="custom-file-label-user" for="file-input">Subir foto...</label>
                                            @error('foto')
                                              <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                              </span>
                                            @enderror
                                        </div>
                                        <div class="p mb-0 font-size-ms text-muted">Sube una foto en formato <strong>.PNG</strong> o <strong>.JPG</strong> <br> <strong>Max. 1Mb</strong></div>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="row">
                                    <div class="col-sm-6">
                                      <div class="form-group">
                                        <label for="account-fn">Nombres</label>
                                        <input class="form-control" name="name" type="text" id="account-fn" value="{{Auth::user()->name}}">
                                      </div>
                                    </div>
                                    <div class="col-sm-6">
                                      <div class="form-group">
                                        <label for="account-email">Correo electrónico</label>
                                        <input class="form-control" type="email" id="account-email" value="{{Auth::user()->email}}" name="email">
                                      </div>
                                    </div>          
                                  </div>                                   
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <br>
                                        <button type="submit" class="btn btn-primary float-right">Actualizar</button>
                                    </div>
                                </div>
                            </form>                                         
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script type="text/javascript">

        function fileValidation(){
            var fileInput = document.getElementById('file-input');
            var filePath = fileInput.value;
            var allowedExtensions = /(.jpg|.jpeg|.png)$/i;
            if(!allowedExtensions.exec(filePath)){
                return false;
            }else{
                return true;     
            }
        }

        document.getElementById("file-input").onchange = function (e) {
        // Creamos el objeto de la clase FileReader

        var validate = fileValidation();

        if (validate) {

          let archivo = document.getElementById("file-input");
          let peso = archivo.files[0].size;
          if(peso > 1000000) {
            Snackbar.show({
              text: 'Archivo muy pesado Tamaño máximo permitido es de 1Mb',
              pos: 'bottom-right',
              actionText:"Ok"
            }); 

            $("#file-input").val(''); 
            $('#custom-file-label-user').html('Subir foto...');

           }else{
              let reader = new FileReader();

              // Leemos el archivo subido y se lo pasamos a nuestro fileReader
              reader.readAsDataURL(e.target.files[0]);

              // Le decimos que cuando este listo ejecute el cÃ³digo interno
              reader.onload = function () {
                  let preview = document.getElementById('preview'),
                      image = document.createElement('img');

                  image.src = reader.result;

                  preview.innerHTML = '';
                  preview.append(image);
              };
           }
        }else{
            var file = $('#file-input').val();

            if (file!='') {
                Snackbar.show({
                  text: 'La extensión de la imagen no es válida, solo se permite extensiones .PNG o .JPG',
                  pos: 'bottom-right',
                  actionText:"Ok"
                }); 
              $('#file-input').val('');
              $('#custom-file-label-user').html('Subir foto...');
            }            
        }
    }

    $('#file-input').change(function () {

        var file = $('#file-input').val();

        if (file == '') {
            $('#preview').html('<img src="/img/profile.png">');
        }
    });
    </script>
@endsection