<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>Panel Administrativo | GuateHoteles</title>
    <link href="<?php echo e(asset('css/loader.css')); ?>" rel="stylesheet" type="text/css" />
    <script src="<?php echo e(asset('js/loader.js')); ?>"></script>

    <link rel="stylesheet" media="screen" id="main-styles" href="<?php echo e(asset('css/theme.min.css')); ?>">
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/perfect-scrollbar.css')); ?>">
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('css/plugins.css')); ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/monokai-sublime.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/sweetalert.css')); ?>">
    <!-- END GLOBAL MANDATORY STYLES -->
    
    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM STYLES -->
    <link href="<?php echo e(asset('css/apexcharts.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('css/dashboard/dash_1.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('css/snackbar.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- END PAGE LEVEL PLUGINS/CUSTOM STYLES -->
    <style type="text/css">
        .custom-file-label::after {
            content: "Buscar";
        }
    </style>
    <?php echo $__env->yieldContent('css'); ?>
</head>
<body>
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
    	<br><br><br><br><br><br><br><br>  
    	<center><img src="<?php echo e(asset('img/logo.png')); ?>" style="max-width: 80%;"></center>
    	<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 792 723" style="enable-background:new 0 0 792 723;" xml:space="preserve"> <g> <circle class="st2" cx="275.4" cy="910" r="65"></circle> <circle class="st4" cx="475.4" cy="910" r="65"></circle> </g> 
    	</svg> 
    </div></div></div>
    <!--  END LOADER -->

    <!--  BEGIN NAVBAR  -->
    <div class="header-container fixed-top">
        <?php echo $__env->make('admin.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--  END NAVBAR  -->

    <!--  BEGIN NAVBAR  -->

    
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container" id="container">

        <div class="overlay"></div>
        <div class="search-overlay"></div>

        <?php echo $__env->make('admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content">
            <div class="layout-px-spacing">
            	<?php echo $__env->yieldContent('content'); ?>
            </div>
            <?php echo $__env->make('admin.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <!--  END CONTENT AREA  -->

    </div>
    <!-- END MAIN CONTAINER -->

    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo e(asset('js/jquery-3.2.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            App.init();
        });
    </script>
    <script type="text/javascript" src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo e(asset('js/snackbar.min.js')); ?>"></script>
    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM SCRIPTS -->
    <script src="<?php echo e(asset('js/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dashboard/dash_1.js')); ?>"></script>
    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM SCRIPTS -->
    <?php echo $__env->yieldContent('script'); ?>

    <?php if(session('success')): ?>
       <script>
            Snackbar.show({
                text: `<?php echo e(session("mensaje")); ?>`,
                pos: 'bottom-right',
                actionText:"Ok"
            });
       </script>            
    <?php endif; ?>
    
       
</body>

<!-- Mirrored from designreset.com/cork/ltr/demo4/ by HTTrack Website Copier/3.x [XR&CO'2014], Thu, 05 Mar 2020 20:43:02 GMT -->
</html><?php /**PATH C:\xampp74\htdocs\guatehoteles\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>