        <nav class="navbar navbar-expand-lg navbar-dark bg-dark py-0">
          <div class="container">
            <div class="collapse navbar-collapse navMenu justify-content-between">
              <div class="d-flex justify-content-end justify-content-lg-start pt-1 pt-lg-0">
                <div class="dropdown">
                  <button class="btn dropdown-toggle btn-dark btn-sm" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <img src="<?php echo e(asset(session('moneda_img'))); ?>" alt="Dolar" class="btn-image">
                    <span>Moneda: <?php echo e(session('moneda_simbolo')); ?></span>
                  </button>
                  <div class="dropdown-menu">
                    <?php $__currentLoopData = $monedas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <a class="dropdown-item" href="<?php echo e(route('moneda',$key->id)); ?>"><?php echo e($key->simbolo); ?> (<?php echo e($key->moneda); ?>)</a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                </div>
              </div>
              <div class="py-1 d-flex align-items-center justify-content-end">
                <?php if(auth()->guard()->check()): ?>  
                  <?php if(Auth::user()->rol_id!=3): ?>
                    <a href="<?php echo e(route('home')); ?>" class="btn btn-primary btn-sm mr-2">Ir al panel</a> 
                  <?php endif; ?> 

                  <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                  </form>

                  <div class="dropdown">
                    <button class="btn btn-secondary btn-sm dropdown-toggle mr-2" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                      <?php echo e(Auth::user()->name); ?>

                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                      <a class="dropdown-item" href="<?php echo e(route('favoritos.index')); ?>">Favoritos</a>
                      <a class="dropdown-item" href="<?php echo e(route('user.cuenta')); ?>">Mi cuenta</a>
                      <a class="dropdown-item" href="<?php echo e(route('user.clave')); ?>">Cambiar contraseña</a>
                      <a class="dropdown-item" href="#" onclick="event.preventDefault();
                            document.getElementById('logout-form').submit();">Cerrar sesión</a>
                    </div>
                  </div>
                                  
                <?php else: ?>
                  <ul class="navbar-nav d-flex flex-row">
                    <li class="nav-item">
                      <a href="<?php echo e(route('login')); ?>" class="text-small nav-link px-2">Iniciar Sesión</a>
                    </li>
                  </ul>
                  <a href="<?php echo e(route('register')); ?>" class="btn btn-primary btn-sm">Registrar</a>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </nav>
        <nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top" style="box-shadow: 0 0 5px grey">
          <div class="container">
            <a class="navbar-brand" href="<?php echo e(asset('')); ?>">
              <img alt="GuateHoteles" src="<?php echo e(asset('img/logo.png')); ?>" style="max-width: 100%; max-height: 50px;">
            </a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target=".navMenu" aria-expanded="false" aria-label="Toggle navigation">
              <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end navMenu">

              <ul class="navbar-nav">

                <li class="nav-item">
                  <a class="nav-link <?php echo e(request()->is('/') ? 'active' : ' '); ?>" href="<?php echo e(asset('')); ?>">Inicio</a>
                </li>

                <li class="nav-item">
                  <a href="<?php echo e(asset('hoteles')); ?>" class="nav-link <?php echo e(request()->is('hoteles') ? 'active' : ' '); ?> <?php echo e(request()->is('hotel/*') ? 'active' : ' '); ?>">Hoteles</a>
                </li>

                <li class="nav-item">
                  <a class="nav-link <?php echo e(request()->is('quienes-somos') ? 'active' : ' '); ?>" href="<?php echo e(route('portal.quienes-somos')); ?>">Quiénes somos</a>
                </li>

                <li class="nav-item">
                  <a class="nav-link <?php echo e(request()->is('preguntas-frecuentes') ? 'active' : ' '); ?>" href="<?php echo e(route('portal.preguntas')); ?>">Preguntas frecuentes</a>
                </li>

                <li class="nav-item">
                  <a class="nav-link <?php echo e(request()->is('contacto') ? 'active' : ' '); ?>" href="<?php echo e(route('portal.contacto')); ?>">Soporte</a>
                </li>

              </ul>
            </div>
          </div>
        </nav><?php /**PATH /home/guatehoteles/test.guatehoteles.com/resources/views/layouts/nav.blade.php ENDPATH**/ ?>