

<?php $__env->startSection('content'); ?>

  <link  href="<?php echo e(asset('css/fotorama.css')); ?>" rel="stylesheet">  
  <link  href="<?php echo e(asset('css/plyr.css')); ?>" rel="stylesheet">

  <style type="text/css">
    @media (min-width: 992px){
      .modal-lg {
          max-width: 1140px;
      }
    }
    
    .loader,
    .loader:after {
      border-radius: 50%;
      width: 10em;
      height: 10em;
    }
    .loader {
        margin: 60px auto;
        font-size: 10px;
        position: relative;
        text-indent: -9999em;
        border-top: 1.1em solid #2196F3;
        border-right: 1.1em solid #2196F3;
        border-bottom: 1.1em solid rgb(0 0 0 / 20%);
        border-left: 1.1em solid #2196F3;
        -webkit-transform: translateZ(0);
        -ms-transform: translateZ(0);
        transform: translateZ(0);
        -webkit-animation: load8 1.1s infinite linear;
        animation: load8 1.1s infinite linear;
    }
    @-webkit-keyframes load8 {
      0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
      }
      100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
      }
    }
    @keyframes  load8 {
      0% {
        -webkit-transform: rotate(0deg);
        transform: rotate(0deg);
      }
      100% {
        -webkit-transform: rotate(360deg);
        transform: rotate(360deg);
      }
    }

  </style>
    <!-- Modal -->
  <div class="modal fade" id="habitacion_modal" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="habitacion_title"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id="habitacion_body">
          
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="telefono" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Teléfonos</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <?php $__currentLoopData = $hotel->contactos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(is_null($key->telefono)==false): ?>
            <div class="contacto" style="padding: 5px; border-radius: 5px; border: solid 1px;">
              <div class="row">
                <div class="col-8">
                  <a href="tel:+502<?php echo e($key->telefono); ?>" class="text-secondary mt-1 ml-2 p-0">
                    +502 <?php echo e($key->telefono); ?> <br>
                    <p class="ml-2">Has clic para llamar</p>
                  </a>
                </div>
                <div class="col-4" style="border-left: solid 1px !important;">
                  <center>
                    <a href="tel:+502<?php echo e($key->telefono); ?>" class="material-icons text-secondary mt-1" style="font-size: 50px;">
                    call
                    </a>
                  </center>
                </div>
              </div>
            </div>
            <br>
            <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal -->
  <link href="https://fonts.googleapis.com/css2?family=Fredoka+One&display=swap" rel="stylesheet">
  <style type="text/css">
    body{
      background: #fff;
    }
    #map{
      width: 100%;
      height: 200px;
      border-radius: 10px;
    }
    #categoria{
      font-size: 40px;
      font-family: 'Fredoka One', cursive;
      margin-top: -40px;
    } 

    .precio{
      float: right;
    }

    .oferta{
      float: right;
    }

    .detalles_precio{
      float: right;
    }
    .detalles_precio_menu{
      margin-left: -110px;
    }
    #content,.notify-r{
      margin-left: 4.5em;
      margin-right: 4.5em;
    }
    .content{
      margin-left: 0.8em;
      margin-right: 0.8em;
    }

    .room_status{
      margin-bottom: 150px;
      position: absolute; 
      padding: 10px; 
      z-index: 200; 
      margin-left: 7px;
    }

    .img-habitacion{
      min-width: 100%; 
      max-width: 100%; 
      min-height: 100%; 
      max-height: 100%;
      position: absolute;
    }

    #text-ubicacion{
      padding: 0px; 
      display: inline-block; 
      font-size: 16px;
    }

    .sh-l{
      border-top-left-radius: 10px;
      border-bottom-left-radius: 10px;
    }

    .sh-r{
      border-top-right-radius: 10px;
      border-bottom-right-radius: 10px;
    }
    .badge-warning {
        background-color: #fea569;
    }
    .badge-warning.badge-shadow {
        box-shadow: 0 0.5rem 1.125rem -0.275rem rgba(254,165,105,0.9);
    }

    .badge-danger {
        color: #fff;
        background-color: #f34770;
    }

    .badge-danger.badge-shadow {
      box-shadow: 0 0.5rem 1.125rem -0.275rem rgba(243,71,112,0.9);
    }
    .btn-primary-box-shadow{
      box-shadow: 0 0.5rem 1.125rem -0.275rem rgba(0, 153, 255,0.9);
    }
    .badge-success.badge-shadow {
        box-shadow: 0 0.5rem 1.125rem -0.275rem rgb(40, 167, 69);
    }

    .badge-success {
        color: #fff;
        background-color: #28a745;
    }
    .politica{
      font-size: 16px !important;
    }
    @media(max-width:768px){
      #content,.notify-r{
        margin-left: 0.5em;
        margin-right: 0.5em;
      }
      .img-habitacion{
        min-width: 100%; 
        max-width: 100%; 
        min-height: 150px; 
        max-height: 150px;
        position: relative;
      }

      #text-ubicacion{
        font-size: 16px;
      }

      #categoria{
        margin-top: 0px;
      }

      .room_status{
        margin-bottom: 100px;
      }

      .precio{
        float: left;
      }

      .detalles_precio{
        float: left;
      }

      .detalles_precio_menu{
        margin-left: -10px;
      }

      .oferta{
        float: left;
      }
    }

</style>
<link  href="<?php echo e(asset('css/fotorama.css')); ?>" rel="stylesheet">

<nav class="navbar navbar-expand-lg d-none d-md-block" style="/*background: #280173;*/ background: linear-gradient(90deg, #0099FF 0%, #6610f2 100%);">
  <div class="pl-3 pr-2">

    <form action="<?php echo e(route('hotel.single',$hotel->url)); ?>" method="get">
      <div class="row">
        <div class="col-md-3">
          <div class="input-group mb-0" style="height: 38px;">
                <div class="input-group-prepend">
                  <div class="input-group-text sh-l" style="background: #e9ecef;">
                    <i class="material-icons">search</i>
                  </div>
                </div>
                <input type="search" class="form-control sh-r" placeholder="Buscar" value="<?php echo e($hotel->nombre); ?>" disabled="disabled">
              </div>
        </div>
        <div class="col-md-3">
          <div class="input-group mb-0">
            <div class="input-group-prepend">
              <div class="input-group-text sh-l">
                <i class="material-icons">calendar_today</i>
              </div>
            </div>
            <input type="date" class="form-control sh-r" placeholder="Fecha de entrada" value="<?php echo e($check_in); ?>" name="check_in">
          </div>
        </div>
        <div class="col-md-3">
          <div class="input-group mb-0">
            <div class="input-group-prepend">
              <div class="input-group-text sh-l">
                <i class="material-icons">calendar_today</i>
              </div>
            </div>
            <input type="date" class="form-control sh-r" placeholder="Fecha de salida" value="<?php echo e($check_out); ?>" name="check_out">
          </div>        
        </div>
        <div class="col-md-2">
          <div class="input-group mb-0" style="height: 38px;">
                <div class="input-group-prepend">
                  <div class="input-group-text sh-l">
                    <i class="material-icons">people</i>
                  </div>
                </div>
                <input type="number" name="huesped" class="form-control sh-r" placeholder="Huespedes" value="<?php echo e($huesped); ?>">
              </div>
        </div>
        <div class="col-md-1">
          <button class="btn btn-primary">Actualizar</button>
        </div>
      </div>
    </form>
  </div>
</nav>
<div class="content">
  <div class="bg-white" style="border-bottom-right-radius: 0px; border-bottom-left-radius: 0px;">
    <?php if($hotel->reclamar == 'S'): ?>
      <div class="row">
        <div class="col notify-r">
          <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <p style="text-align: justify;">La información publicada en esta página puede ser errónea debido a que este hotel no fue reclamado por el propietario del hotel. Si usted es el propietario, por favor siga los paso para adquirid este hotel en su cuenta y poder modificar la información que esta publicada en esta página <a href="<?php echo e(route('hotel.reclamar',$hotel->id)); ?>">Soy el propietario de este hotel</a></p>

              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
          </div>
        </div>
      </div>
    <?php endif; ?>
    <div class="row">
      <div class="col-md-6">
        <div class="ml-3">
          <h4 class="mt-2 mb-0 pb-0"><?php echo e($hotel->nombre); ?></h4>
          <?php for($e=0;$e<$hotel->estrellas;$e++): ?>
            <i class="material-icons text-warning" style="display: inline-block; font-size: 18px;">star</i>
          <?php endfor; ?>
          <br>
          <div class="text-primary">
            Dirección:
              <p id="text-ubicacion">
                  <?php echo e(Str::limit($hotel->ubicacion->direccion,'80')); ?> </p>
            <br>
            <i class="material-icons"style="font-size: 18px" >location_on</i> 
            <p id="text-ubicacion">
              <?php echo e($hotel->ubicacion->municipio->municipio); ?> -
              <?php echo e($hotel->ubicacion->departamento->departamento); ?>

            </p>
          </div>
        </div>
      </div>
      <div class="col-md-6 d-none d-md-block">
        <div style="width: 100%;">
          <div style="display: inline-block;" class="mr-1">
            <center><h6>Tarjetas aceptadas por el hotel</h6></center>
              <?php $__currentLoopData = $hotel->tarjetas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <img src="<?php echo e(asset($key->tarjeta->img)); ?>" class="bs-tooltip mr-1" 
                     data-toggle="tooltip" 
                     title="<?php echo e($key->tarjeta->nombre); ?>" style="display: inline-block;">
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>

          <div style="display: inline-block;" class="mr-2">
            <center>
              <h6 class="m-0 p-0 mt-1">Calificación</h6>          
              <div class="bg-primary text-white" style="border-radius: 50%; padding: 5px; width: 80px;height: 80px;">
                <h6 class="text-white mt-3">
                  <?php if($comentarios == 0): ?>
                    0
                  <?php else: ?>
                    <?php $promedio = round(($hotel->valoracion() / $comentarios), 2); ?>
                    <?php echo e($promedio); ?>

                  <?php endif; ?>
                  /<small>5</small>
                </h6>
              </div>
            </center>
          </div>

          <div style="display: inline-block;">
            <div class="row">
              <div class="col">
                <center>
                <?php if(auth()->guard()->check()): ?>
                  <?php if(Auth::user()->favoritos($hotel->id) > 0): ?>
                    <a href="<?php echo e(route('favoritos.favoritos',$hotel->id)); ?>" class="text-danger">
                      <i class="material-icons text-danger" style="font-size: 50px;">favorite</i>
                      <p class="text-danger"><strong>Eliminar</strong></p>
                    </a> 
                  <?php else: ?>
                    <a href="<?php echo e(route('favoritos.favoritos',$hotel->id)); ?>" class="text-danger">
                      <i class="material-icons text-danger" style="font-size: 50px;">favorite_border</i>
                      <p class="text-danger"><strong>Agregar</strong></p>
                    </a>
                  <?php endif; ?>
                <?php else: ?>
                  <a href="#" class="text-danger">
                    <i class="material-icons text-danger" style="font-size: 50px;">favorite_border</i>
                    <p class="text-danger"><strong>Agregar</strong></p>
                  </a>
                <?php endif; ?>
                </center> 
              </div>
            </div>      
          </div>
        </div>
        
      </div>
    </div>
    <div class="row mt-0">
        <div class="col-12 d-none d-md-block" id="container-nav-div">
          <ul class="nav" style="font-size: 15px;" id="onepage">
            <li class="nav-item" style="border-bottom: 3px solid #0099FF;">
              <a class="nav-link text-primary active" href="#resumen" >Resumen</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#habitacion">Habitaciones</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#ubicacion">Ubicación</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#servicios">Servicios</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#descripcion">Descripción</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#comentarios">Comentarios</a>
            </li>
          </ul>
        </div>
    </div>
  </div>

  <div class="bg-white" id="resumen">
    <div class="row">
      <div class="col-md-8">
        <div class="fotorama" 
          data-nav="thumbs"
          data-width="100%"
          data-allowfullscreen="true"
          >        
          <?php if($hotel->imagenes->count() == 0 || is_null($hotel->imagenes) ): ?>
            <a href="<?php echo e(asset('img/hotel.png')); ?>">
              <img src="<?php echo e(asset('img/hotel.png')); ?>"/>
            </a>
          <?php else: ?>
            <?php $__currentLoopData = $hotel->imagenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <a href="<?php echo e(asset($key->img)); ?>">
                <img class="carousel-cell-image" src="<?php echo e(asset($key->img)); ?>" style="min-width: 100% !important; max-width: 100% !important;" />
              </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        </div>
        
      </div>
      <div class="col-md-4">
        <div style="width: 100%; border-radius: 5px; padding: 5px; border: solid 2px #e2f0ff;" id="categoria">
          <center>
            <?php if($hotel->logo): ?>
             <img src="<?php echo e(asset($hotel->logo)); ?>"/> 
             <?php else: ?>
              <?php echo e($hotel->categoria->categoria); ?>

            <?php endif; ?>
          </center>
        </div>
        <div style="padding: 5px;">

          <?php $video = video_hotel($hotel->video);?>

          <?php if($video==1): ?>
            <video style="width: 100%; height: 200px;"
            controls
            crossorigin
            playsinline
            id="player"
          ></video>

          <?php else: ?>
            <?php if($video['video']=='youtube'): ?>
              <div id="player" data-plyr-provider="youtube" data-plyr-embed-id="<?php echo e($video['link']); ?>" style="width: 100%; height: 200px;"></div>
            <?php endif; ?>

            <?php if($video['video']=='vimeo'): ?>
              <div class="plyr__video-embed" id="player" style="width: 100%; height: 200px;">
                <iframe
                  src="<?php echo e($video['link']); ?>"
                  allowfullscreen
                  allowtransparency
                  allow="autoplay"
                ></iframe>
              </div>
            <?php endif; ?>

          <?php endif; ?>

        

        <div id="map" class="mt-1"></div>
        </div>
        <div class="contacto" style="padding: 10px; border-radius: 5px; border: solid 1px;">
          <div class="row">
            <div class="col-8">
              <i class="material-icons" style="position: absolute;">call</i>
              <a href="#telefono" class="text-secondary ml-3 mb-2" data-toggle="modal" data-target="#telefono">
                Llamar ahora
              </a><br>
              <div class="m-1"></div>
              <i class="material-icons" style="position: absolute;">email</i> 
              <a href="<?php echo e(route('hotel.mensaje',$hotel->id)); ?>" class="text-secondary ml-3 mb-2">
                Enviar un correo
              </a>
              <?php if(is_null($hotel->web)==false): ?>
                <div class="m-1"></div>
                <i class="material-icons" style="position: absolute;">web</i> 
                <a href="<?php echo e($hotel->web); ?>" target="_black" class="text-secondary ml-3 mb-2">
                  Ir al sitio web
                </a>
              <?php endif; ?>
            </div>
            <div class="col-4" style="border-left: solid 1px !important;">
              <center>
                <?php if(is_null($hotel->web)==false): ?>
                  <br>
                <?php endif; ?>
                <span class="material-icons" style="font-size: 60px;">
                contact_phone
                </span>
              </center>
            </div>
          </div>
        </div>
          <?php if($hotel->recomendaciones->count() != 0): ?>
            <strong>recomendado por:</strong><br>
              <div class="row">
                <?php $__currentLoopData = $hotel->recomendaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="col">
                    <center>
                      <img src="<?php echo e(asset($key2->empresa->logo)); ?>" width="140px" height="60px">
                    </center>
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                         
              </div>
          <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <center><h4 class="mt-4 d-none d-md-block">Servicios</h4></center>
      <div class="ml-0 mr-0">
        <div data-flickity='{"contain": true, "pageDots":true, "wrapAround":true, "autoPlay":false, "imagesLoaded":true, "groupCells": 3,"freeScroll": true}' class="d-none d-md-block">       
          <?php $ser_cant = $hotel->servicios_principales_count(); ?>                    
              
              <?php $i = $hotel->servicios_principales_count(); ?>
              

              <?php $i_ser = 1; $i=0; ?>
              <?php 
                $ser_cant = $hotel->servicios_principales_count();
                if ($ser_cant >= 5) {
                  $cant=2;
                }else{
                  if ($ser_cant!=0) {
                    $cant =  12 / $ser_cant;
                  }                  
                } 
                
                $data = $hotel->servicios_principales();
              ?>      

              <?php for($i=0; $i<($ser_cant*2); $i++): ?>
                <div class="col-<?php echo e($cant); ?>" style="padding: 0px; ">
                    <center>
                      <img style="display: inline-block; width: 25px !important;" class="material-icons" 
                      src="<?php echo e(asset($data[$i])); ?>" data-toggle="tooltip" data-placement="top" 
                      <?php $i++; ?>
                      title="<?php echo e($data[$i]); ?>">
                    </center>
                </div>
              <?php endfor; ?>           
          </div>
      </div>
    </div>
  </div>

  <div id="habitacion"></div>
  <div class="mt-4"><br></div>
</div>
<div style="background: #f1f1f1;">
  <div class="content">
    <div class="container">
      <br><br>
      <h5>Elige las fechas para ver la disponibilidad</h5>
      <form action="<?php echo e(route('hotel.single',$hotel->url)); ?>" method="get">
        <div class="row">
            <div class="col-md-4">
              <h6>Fecha de entrada</h6>
              <div class="input-group mb-2">
                <div class="input-group-prepend">
                  <div class="input-group-text sh-l">
                    <i class="material-icons">calendar_today</i>
                  </div>
                </div>
                <input type="date" class="form-control form-control-lg sh-r" placeholder="Fecha de entrada" value="<?php echo e($check_in); ?>" name="check_in">
              </div>
            </div>
            <div class="col-md-4">
              <h6>Fecha de salida</h6>
              <div class="input-group mb-2">
                <div class="input-group-prepend">
                  <div class="input-group-text sh-l">
                    <i class="material-icons">calendar_today</i>
                  </div>
                </div>
                <input type="date" class="form-control form-control-lg sh-r" placeholder="Fecha de salida" value="<?php echo e($check_out); ?>" name="check_out">
              </div>
            </div>
            <div class="col-md-3">
              <h6>Huespedes</h6>
              <div class="input-group mb-2" style="height: 50px;">
                <div class="input-group-prepend">
                  <div class="input-group-text sh-l">
                    <i class="material-icons">people</i>
                  </div>
                </div>
                <input type="number" class="form-control form-control-lg sh-r" placeholder="Huespedes" value="<?php echo e($huesped); ?>" name="huesped">
              </div>
            </div>
            <div class="col-md-1">
              <h6><br></h6>
              <button class="btn btn-lg btn-primary" type="submit">Actualizar</button>
            </div>
        </div>
      </form><br>
      <?php $__currentLoopData = $hotel->habitaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-md-12">
        <div class="card" style="border-radius: 10px; box-shadow: 0 0 3px grey;">
          <div class="row">
            <div class="col-md-4">
              <?php if($check_in!='' && $check_out!=''): ?>
                <?php if($huesped <= $key->huesped): ?>

                  <?php if($key->disponibilidad($check_in,$check_out) > 0): ?>
                    <span class="badge badge-success badge-shadow room_status">Disponible</span>
                  <?php else: ?>
                      <span class="badge badge-danger badge-shadow room_status">No disponible</span>
                  <?php endif; ?>
                <?php else: ?>
                  <span class="badge badge-warning text-white badge-shadow room_status">No se cuenta con el número de huéspedes solicitados</span>
                <?php endif; ?>
              <?php endif; ?>

              <?php if($key->imagenes->count() == 0): ?>
                <a href="#">
                  <img class="img-habitacion" src="<?php echo e(asset('img/habitacion.png')); ?>" alt="Habitacion" style="min-width: 100%; max-width: 100%;" />
                </a>            
                <?php else: ?>
                  <a href="#">
                    <img class="img-habitacion" src="<?php echo e(asset($key->imagenes[0]->img)); ?>" alt="Habitacion"  />
                  </a>              
                <?php endif; ?>   
            </div>
            <div class="col-md-8">
              <div class="card-body" style="min-height: 200px;">
                <div class="row">
                  <div class="col-md-7">
                    <h5><?php echo e($key->nombre); ?></h5>
                    <div class="mb-2"></div>
                    <div class="row p-0 m-0">
                      <div class="col-md-6 p-0 m-0 mt-1 mb-1">
                        <i class="material-icons text-secondary mb-0" style="position: absolute;">people</i> 
                        <p class="ml-4 mb-0 text-secondary" style="display: inline-block;">Duerme <?php echo e($key->huesped); ?></p>
                      </div>

                      <div class="col-md-6 p-0 m-0 mt-1 mb-1">
                        <svg aria-hidden="true" height="24px" fill="#6c757d"  viewBox="0 0 24 24" width="24px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><svg><path d="M5.995 17.997h2l-3 3-3-3h2V6a2 2 0 0 1 2-2H18V2l3 3-3 3V6H5.995v11.997zm14-7.997v2h-2v-2h2zm0 8a2 2 0 0 1-2 2v-2h2zm0-4v2h-2v-2h2zm-4 4v2h-2v-2h2zm-4 0v2h-2v-2h2z"></path></svg></svg>
                        <p style="display: inline-block;" class="mb-0"><?php echo e($key->size); ?> metros cuadrados</p>
                      </div>

                      <?php if($key->camas->where('id_tipo_cama',1)->first()->cantidad > 0): ?>
                        <div class="col-md-6 m-0 p-0 mt-1 mb-1">
                          <i class="material-icons text-secondary mb-0" style="position: absolute;">hotel</i> 
                          <p class="ml-4 mb-0 text-secondary" style="display: inline-block;"><?php echo e($key->camas->where('id_tipo_cama',1)->first()->cantidad); ?> cama individual</p>
                        </div>
                      <?php endif; ?>

                      <?php if($key->camas->where('id_tipo_cama',2)->first()->cantidad > 0): ?>
                        <div class="col-md-6 m-0 p-0 mt-1 mb-1">
                          <i class="material-icons text-secondary mb-0" style="position: absolute;">king_bed</i> 
                          <p class="ml-4 mb-0 text-secondary" style="display: inline-block;"><?php echo e($key->camas->where('id_tipo_cama',2)->first()->cantidad); ?> cama grande</p>
                        </div>
                      <?php endif; ?>
                    </div>
                    <br>
                    <div style="position: absolute;
                      bottom: 0;
                      left: 0;
                      right: 0;">

                      <br>
                    
                      <center><a href="javascript:habitacion(<?php echo e($key->id); ?>,'<?php echo e($key->nombre); ?>','<?php echo e(route('habitacion.single',[$hotel->url,$key->id])); ?>')" class="mb-1">Mostrar detalles</a></center>
                    </div>
                  </div>
                  <div class="col-md-5">
                  	<?php if($key->precio(session('id_moneda'))->oferta > 0 &&  is_null($key->precio(session('id_moneda'))->oferta)==false): ?>
	                    <span class="badge badge-danger badge-shadow oferta mt-1">
	                    	<?php echo e($key->precio(session('id_moneda'))->oferta); ?> % de descuento
	                    </span>
                    <?php endif; ?>

                    <div class="mt-2"><br></div>
                  <div class="precio">

                    <?php if($key->precio(session('id_moneda'))->oferta > 0 &&  is_null($key->precio(session('id_moneda'))->oferta)==false): ?>
                      <h5 style="display: inline-block;" class="text-secondary mb-0">
                      	<strike>
                      	 	<?php if(session('id_moneda')==2): ?> Q <?php endif; ?>
                          	<?php if(session('id_moneda')==1): ?> $ <?php endif; ?>
                          	<?php echo e($key->precio_old(session('id_moneda'))); ?>                     	  
                      	</strike>  
                   	  </h5> 
                   	<?php endif; ?>

                      <h4 style="display: inline-block; color:  #f34770;" class=" mb-0">
                      	<?php if(session('id_moneda')==2): ?> Q <?php endif; ?>
                        <?php if(session('id_moneda')==1): ?> $ <?php endif; ?>
                      	<?php echo e($key->precio_total(session('id_moneda'))); ?>

                      </h4><br>

                      <small class="m-0">Por noche</small><br>
                          <a href="#" class="dropdown-toggle detalles_precio" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Detalles del precio</a>
                          <div class="dropdown-menu detalles_precio_menu" style="left: -110px !important;
                            width: 95% !important; font-size: 14px;">
                            <div class="p-1">
                              <center><h5>Detalles del precio</h5></center>

                                <p style="display: inline-block;">
                                  1 habitación por noche :
                                </p> 
                                <p style="display: inline-block; float: right;">
                                <?php if(session('id_moneda')==2): ?> Q <?php endif; ?>
                          		<?php if(session('id_moneda')==1): ?> $ <?php endif; ?>
                                 <?php echo e($key->precio_sin_impuesto(session('id_moneda'))); ?></p>
                               <br>

                               <p style="display: inline-block;">
                                  IVA (<?php echo e($key->precio(session('id_moneda'))->IVA); ?>%):
                                </p> 
                                <p style="display: inline-block; float: right;">
                                <?php if(session('id_moneda')==2): ?> Q <?php endif; ?>
                          		<?php if(session('id_moneda')==1): ?> $ <?php endif; ?>
                                 
                                 	<?php echo e(($key->precio(session('id_moneda'))->IVA * $key->precio(session('id_moneda'))->precio) / 100); ?>

                                 </p>
                               <br>

                               <p style="display: inline-block;">
                                  ISR (<?php echo e($key->precio(session('id_moneda'))->ISR); ?>%):
                                </p> 
                                <p style="display: inline-block; float: right;">
                                	<?php if(session('id_moneda')==2): ?> Q <?php endif; ?>
                          			<?php if(session('id_moneda')==1): ?> $ <?php endif; ?>

                                <?php echo e(($key->precio(session('id_moneda'))->ISR *  $key->precio(session('id_moneda'))->precio ) / 100); ?>

                             	</p>
                               <br>

                               <?php if(is_null($key->precio(session('id_moneda'))->INGUAT)==false): ?>
	                               <p style="display: inline-block;">
	                                  Inguat (<?php echo e($key->precio(session('id_moneda'))->INGUAT); ?>%):
	                                </p> 
	                                <p style="display: inline-block; float: right;">
	                                	<?php if(session('id_moneda')==2): ?> Q <?php endif; ?>
                          				<?php if(session('id_moneda')==1): ?> $ <?php endif; ?>
                          				<?php echo e(($key->precio(session('id_moneda'))->INGUAT *  $key->precio(session('id_moneda'))->precio) / 100); ?>

	                            	</p>
	                               <br>
                               <?php endif; ?>

                               <p style="display: inline-block; font-size: 18px;">
                                  <strong>Total:</strong>
                                </p> 
                                <p style="display: inline-block; float: right; font-size: 18px;"><strong>
                                	<?php if(session('id_moneda')==2): ?> Q <?php endif; ?>
                          			<?php if(session('id_moneda')==1): ?> $ <?php endif; ?>
                          			<?php echo e($key->precio_total(session('id_moneda'))); ?></strong></p>
                               <hr>
                               <center>
                                <?php if($reserva_url!=''): ?>
                                  <a href="<?php echo e(route('hotel.reserva',$key->id)); ?><?php echo e($reserva_url); ?>" class="btn btn-primary btn-primary-box-shadow">Reservar ahora!</a>
                                <?php else: ?>
                                  <div class="alert alert-info" role="alert">
                                    Seleccione una fecha para poder solicitar una reservación 
                                  </div>
                                <?php endif; ?>
                              </center>
                            </div>
                              
                          </div>
                      <br>
                      <center>
                        <?php if($reserva_url!=''): ?>
                          <a href="<?php echo e(route('hotel.reserva',$key->id)); ?><?php echo e($reserva_url); ?>" class="btn btn-primary btn-primary-box-shadow mt-1">Reservar ahora!</a>
                        <?php else: ?>
                         <button class="btn btn-primary btn-primary-box-shadow mt-1" disabled="disabled" title="Seleccione una fecha para poder solicitar una reservación ">Reservar ahora!</button>
                        <?php endif; ?>
                      </center>
                    </div>
                    <div class="row m-0 p-0 mt-1" style="float: right;">
                        <div class="col m-0 p-0">

                          <!--<i class="material-icons text-success mb-0" style="position: absolute; font-size: 15px; float: right; margin-left: 90px;">check</i>
                          <p class="ml-1 mb-0 text-success" style="display: inline-block; font-size: 15px; float: right; ">Pago: no reembolsable</p> <br>

                          <i class="material-icons text-success mb-0" style="position: absolute; font-size: 15px; margin-left: 90px;">check</i>

                          <p class="mb-0 text-success" style="display: inline-block; font-size: 15px;     margin-left: 110px; ">Cancelación gratis</p> -->

                          <!--<span class="badge badge-warning badge-shadow text-white" style="float: right; padding: 10px;">
                            <strong>Nos queda 1 disponible</strong>
                          </span> -->                   

                        </div>
                      </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <div id="ubicacion"></div>
    <br><br>
    
    <div class="m-2"><br></div>
    <div class="mt-2">
      <div class="bg-white">
        <div class="row bg-white" style="border-radius: 10px;">
          <div class="col-md-5 pr-0 mr-0 pl-0 ml-0">
            <div class="p-3">
              <h4><?php echo e($hotel->nombre); ?></h4><br>
              <?php echo e($hotel->descripcion_corta); ?>

            </div>
          </div>
          <div class="col-md-7 pr-0 mr-0 pl-0 ml-0">
            <div class="p-3">
              <div id="map1" style="height: 400px; border-radius: 10px;"></div>
            </div>
          </div>
        </div>
        <div id="servicios"></div>
      </div>
    </div>
    <div class="mt-3"></div>
     <div class="pt-2"></div>
      <div class="row mt-3 bg-white p-2" style="border-radius: 10px;">
        <div class="col-md-4 mt-2">
          <center><h4 class="mt-3">Servicios del establecimiento</h4></center>
        </div>
        <div class="col-md-7">
          <div class="row">
            <?php $x=0; 

            $servicios_establecimiento = $hotel->servicios_establecimiento_principales();
            $numero_servicios = sizeof($servicios_establecimiento);

            ?>
            <?php for($i=0; $i<$numero_servicios; $i++): ?>                

              <div class="col-md-6 mt-3" style="padding: 0px; ">
                  <img style="display: inline-block; width: 40px !important; position: absolute;" class="material-icons" 
                        src="<?php echo e(asset($servicios_establecimiento[$i])); ?>" data-toggle="tooltip" data-placement="top" 
                        title="">
                  <?php $i++; ?>
                  <h6 style="display: inline-block;" class="ml-5 mt-2"><?php echo e($servicios_establecimiento[$i]); ?></h6>
                  <div class="ml-5">
                    <?php $i++; ?>
                    
                    <!-- subservicios($i)-->
                    <?php $__currentLoopData = $hotel->subservicios_establecimiento($servicios_establecimiento[$i]); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <li style="list-style: none;" class="mt-1">
                        <?php echo e($key->servicio->servicio); ?>

                      </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                  </div>
                  <?php $x++; ?>
              </div>
              
            <?php endfor; ?>

            <?php if($hotel->otros_servicios_establecimiento()->count() > 0): ?>
              <div class="col-md-6 mt-3" style="padding: 0px; ">
                  <img style="display: inline-block; width: 40px !important; position: absolute;" class="material-icons" 
                        src="<?php echo e(asset('img/servicios/check.svg')); ?>" data-toggle="tooltip" data-placement="top" 
                        title="">
                  <?php $i++; ?>
                  <h6 style="display: inline-block;" class="ml-5 mt-2">Otros Servicios</h6>
                  <div class="ml-5">
                    <?php $i++; ?>
                    
                    <!-- subservicios($i)-->
                    <?php $__currentLoopData = $hotel->otros_servicios_establecimiento(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <li style="list-style: none;" class="mt-1">
                        <?php echo e($key->servicio->servicio); ?>

                      </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                  </div>
                  <?php $x++; ?>
              </div>
            <?php endif; ?>
            
          </div>
        </div>
      </div>

    <div class="mt-3"></div>
     <div class="pt-2"></div>
      <div class="row mt-3 bg-white p-2" style="border-radius: 10px;">
        <div class="col-md-4 mt-2">
          <center><h4 class="mt-3">Políticas</h4></center>
        </div>
        <div class="col-md-7 politica">
          <div class="row">
            <div class="col-md-6">
              <h5>Check-in</h5>
              <p>Entrada de <?php echo e($hotel->entrada_desde); ?> a <?php echo e($hotel->entrada_hasta); ?></p>
              <p>Edad mínima para realizar el registro de entrada: <?php echo e($hotel->edad_minima_registro_entrada); ?> años</p>

              <?php if(is_null($hotel->edad_minima)): ?>
                 <p>No existen restricciones de edades para la entrada al hotel</p>
              <?php else: ?>
                <p>Edad mínima para ingresar al hotel: <?php echo e($hotel->edad_minima); ?> <?php if($hotel->edad_minima==1): ?> Año <?php else: ?> Años <?php endif; ?></p>
              <?php endif; ?>

            </div>
            <div class="col-md-6">
              <h5>Check-out</h5>
              <p>Salida: <?php echo e($hotel->salida); ?></p>
              
            </div>

            <div class="col-md-12">
              <h5>Mascotas</h5>

              <?php if($hotel->mascotas == 'S'): ?>

              Aceptamos mascotas

              <?php if($hotel->mascotas_costo_adicional=='S'): ?>
                con costo adicional
              <?php else: ?>
                sin costo adicional
              <?php endif; ?>

            <?php else: ?>               
              No aceptamos mascotas
            <?php endif; ?> 

            </div>

            <div class="col-md-12">
              <br>
              <h5>Cunas</h5>
              <p>
                <?php if($hotel->cunas == 'N'): ?>
                  <p>No ofrecemos cunas en el hotel</p>
                <?php endif; ?>

                <?php if($hotel->cunas == 'S'): ?>
                  <p>Ofrecemos cunas en el hotel</p>
                <?php endif; ?>               
              </p>
            </div>

            <div class="col-md-12"> 
              <br>             
              <h5>Formas de pago</h5>
                <?php $__currentLoopData = $hotel->tarjetas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <img src="<?php echo e(asset($key->tarjeta->img)); ?>" class="bs-tooltip mr-1" 
                         data-toggle="tooltip" 
                         title="<?php echo e($key->tarjeta->nombre); ?>" style="display: inline-block;">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div id="descripcion"></div>
                <br><br>
            </div>
          </div>
        </div>
      </div>

    <div class="mt-3"></div>
     <div class="pt-2"></div>
      <div class="row mt-3 bg-white p-2" style="border-radius: 10px;">
        <div class="col-md-4 mt-2">
          <center><h4 class="mt-3">Infomarción Importante</h4></center>
        </div>
        <div class="col-md-7">
          <div class="row">
            <div class="col-md-12 mb-3">
              <h5>Información Importante</h5>
              <?php echo e($hotel->informacion_importante); ?>

            </div>

            <div class="col-md-12">
              <h5>Aviso Importante</h5>
              <?php echo e($hotel->aviso_importante); ?>

              <div id="descripcion"></div>
              <br><br>
            </div>
          </div>
        </div>
      </div>

    <div class="mt-3"></div>
     <div class="pt-2"></div>
      <div class="row mt-3 bg-white p-2" style="border-radius: 10px;">
        <div class="col-md-4 mt-2">
          <center><h4 class="mt-3">Descripción</h4></center>
        </div>
        <div class="col-md-7">
          <div class="row">
            <div class="col-md-12 p-2">
              <?php echo $hotel->descripcion; ?>

            </div>
          </div>
        </div>
      </div>

      <div id="comentarios">
    <div class="pt-4"><br><br></div>
    <div class="row mt-3">
      <div class="col-md-4">
        <center>
          <h4 class="mt-3"> <strong><?php echo e($comentarios); ?></strong> Comentarios</h4>
          <br>
          <div class="bg-primary text-white" style="border-radius: 50%; padding: 5px; width: 200px;height: 200px;">
              <h1 class="text-white mt-5">
                <?php if($comentarios == 0): ?>
                  0
                <?php else: ?>
                  <?php $promedio = round(($hotel->valoracion() / $comentarios), 2);  ?>
                  <?php echo e($promedio); ?>

                  <?php endif; ?>
                /<small>5</small><br><small>
                  <?php if($comentarios == 0): ?>
                    Sin comentarios
                  <?php else: ?>
                    <?php if($promedio>=4 && $promedio <=5): ?> Excelente <?php endif; ?>
                    <?php if($promedio>=3 && $promedio < 4): ?> Buena <?php endif; ?>
                    <?php if($promedio>=2 && $promedio <3): ?> Aceptable <?php endif; ?>
                    <?php if($promedio>=1 && $promedio <2): ?> Mala <?php endif; ?>
                    <?php if($promedio>=0 && $promedio <1): ?> Muy Mala <?php endif; ?>
                  <?php endif; ?>
                </small></h1>
          </div>
        </center>
      </div>
      <div class="col-md-8">
        <div class="p-2">
                <h6>Excelente - <?php echo e($x5); ?> Votos</h6>
                <div class="progress mb-2">
                  <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($porcentaje[0]); ?>%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="<?php echo e($porcentaje[0]); ?>">
                    <div class="d-flex justify-content-between">
                      <span><?php echo e($porcentaje[0]); ?>%</span>
                    </div>
                  </div>
                </div>

                <h6>Bueno - <?php echo e($x4); ?> Votos</h6>
                <div class="progress mb-2">
                  <div class="progress-bar bg-primary" role="progressbar" style="width: <?php echo e($porcentaje[1]); ?>%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="<?php echo e($porcentaje[1]); ?>">
                    <div class="d-flex justify-content-between">
                      <span><?php echo e($porcentaje[1]); ?>%</span>
                    </div>
                  </div>
                </div>

                <h6>Aceptable - <?php echo e($x3); ?> Votos</h6>
                <div class="progress mb-2">
                  <div class="progress-bar bg-warning" role="progressbar" style="width: <?php echo e($porcentaje[2]); ?>%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="<?php echo e($porcentaje[2]); ?>">
                    <div class="d-flex justify-content-between">
                      <span></span>
                      <span><?php echo e($porcentaje[2]); ?>%</span>
                    </div>
                  </div>
                </div>

                <h6>Malo - <?php echo e($x2); ?> Votos</h6>
                <div class="progress mb-2">
                  <div class="progress-bar bg-danger" role="progressbar" style="width: <?php echo e($porcentaje[3]); ?>%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="<?php echo e($porcentaje[3]); ?>">
                    <div class="d-flex justify-content-between">
                      <span></span>
                      <span><?php echo e($porcentaje[3]); ?>%</span>
                    </div>
                  </div>
                </div>

                <h6>Muy Malo - <?php echo e($x1); ?> Votos</h6>
                <div class="progress mb-2">
                  <div class="progress-bar bg-danger" role="progressbar" style="width: <?php echo e($porcentaje[4]); ?>%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="<?php echo e($porcentaje[4]); ?>">
                    <div class="d-flex justify-content-between">
                      <span></span>
                      <span><?php echo e($porcentaje[4]); ?>%</span>
                    </div>
                  </div>
                </div>         
                
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-8">
              <?php $i=0; ?>
              <?php $__currentLoopData = $hotel->comentarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php $i=1; ?>
                <div class="card">
                  <div class="card-header">
                    <div class="row">
                      <!--<img src="<?php echo e(asset('img/profile-16.jpg')); ?>" width="80px" style="border-radius: 50%; display: inline-block;">-->
                      <h5 class="ml-3 mt-2 text-secondary" style="display: inline-block;">
                        <?php echo e($key->user->name); ?>

                      </h5>
                    </div>
                  </div>
                  <div class="card-body" style="text-align: justify;">
                    <?php echo e($key->comentario); ?>

                  </div>
                  <div class="card-footer">
                    <?php echo e($key->created_at); ?>

                    <div class="bg-dark text-white" style="min-width: 130px; max-width: 130px; float: right; border-radius: 5px;">
                    <strong><center>Calificación : <?php echo e($key->calificacion); ?></center></strong>
                  </div>
                  </div>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php if($i==0): ?>
                <center>
                  <br><br><br><br>
                  <i class="material-icons" style="font-size: 250px;">search</i>
                  <br>
                  <h4>No hay comentarios todavía</h4>
                </center>
              <?php endif; ?>
            </div>
            <div class="col-md-4">
              <div class="card">
                <div class="card-body">
                  <?php if(auth()->guard()->check()): ?>

                  <form 
                      <?php $CU=0;  ?>
                      <?php if(auth()->guard()->check()): ?>
                        <?php if($user_comentario != ''): ?>
                          <?php if($user_comentario->count() >0): ?>
                            <?php $CU =1; ?>
                            action="<?php echo e(route('comentario.update')); ?>"
                          <?php else: ?>
                            action="<?php echo e(route('comentario.add')); ?>"
                          <?php endif; ?>
                        <?php else: ?>
                          action="<?php echo e(route('comentario.add')); ?>"
                        <?php endif; ?>
                      <?php else: ?>
                        action="<?php echo e(route('comentario.add')); ?>"
                      <?php endif; ?>
                       

                    method="post">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id_hotel" value="<?php echo e($hotel->id); ?>">
                    <h5>¿Nos darías tu opinión ?</h5>
                    <hr>
                    <h6>Valoración <strong class="text-danger">*</strong></h6>
                    <select class="form-control form-control-lg text-secondary" name="valoracion" required="required">
                      <option value="">Seleccione una opción</option>
                      <option value="1"
                        <?php if($CU ==1): ?>
                          <?php if($user_comentario->calificacion == 1): ?>
                            selected="selected"
                          <?php endif; ?>
                        <?php endif; ?>
                      >1 Muy mala</option>
                      <option value="2"
                        <?php if($CU ==1): ?>
                          <?php if($user_comentario->calificacion == 2): ?>
                            selected="selected"
                          <?php endif; ?>
                        <?php endif; ?>
                      >2 Mala</option>
                      <option value="3"
                        <?php if($CU ==1): ?>
                          <?php if($user_comentario->calificacion == 3): ?>
                            selected="selected"
                          <?php endif; ?>
                        <?php endif; ?>
                      >3 Aceptable</option>
                      <option value="4"
                        <?php if($CU ==1): ?>
                          <?php if($user_comentario->calificacion == 4): ?>
                            selected="selected"
                          <?php endif; ?>
                        <?php endif; ?>
                      >4 Buena</option>
                      <option value="5"
                        <?php if($CU ==1): ?>
                          <?php if($user_comentario->calificacion == 5): ?>
                            selected="selected"
                          <?php endif; ?>
                        <?php endif; ?>
                      >5 Excelente</option>
                    </select>
                    <br>
                    <h6>Comentario <strong class="text-danger">*</strong></h6>
                    <textarea class="form-control" name="comentario" required="required" maxlength="300" placeholder="Cuéntanos tu experiencia con este hotel" style="min-height: 200px;"><?php if($CU==1): ?><?php echo e($user_comentario->comentario); ?> <?php endif; ?></textarea>
                    <br>
                    <button type="submit" class="btn btn-primary" style="width: 100%;"><?php if($CU==0): ?> Enviar <?php else: ?> Atualizar <?php endif; ?></button>
                  </form>
                  <?php else: ?>
                    <center>
                      <br>
                      <h3 class="h4 pb-2">Inicia sesión en tu cuenta</h3>
                      <p>Inicia sesión para poder proporcionar un comentario</p>
                      <br>
                      <a href="<?php echo e(route('login')); ?>" class="btn btn-primary">Iniciar sesión ahora</a>
                    </center>
                  <?php endif; ?>
                </div>
              </div>
            </div>
    </div>
  </div>
    </div>    
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<?php $api_key = env('KEY_GOOGLE_MAP'); ?>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $api_key; ?>&callback=initMap" 
        async defer>
</script>

<script type="text/javascript">
  function habitacion(id){
    $('#modal-habitacion-'+id).modal('show');
  }
  function initMap() {
          var map = new google.maps.Map(document.getElementById('map'), {
            center: {lat: <?php echo $hotel->ubicacion->latitud; ?> , lng: <?php echo $hotel->ubicacion->longitud; ?>},
            zoom: 16
          });
          var marker = new google.maps.Marker({
            position: {lat: <?php echo $hotel->ubicacion->latitud; ?> , lng: <?php echo $hotel->ubicacion->longitud; ?>},
            map: map,
          });

          var map1 = new google.maps.Map(document.getElementById('map1'), {
            center: {lat: <?php echo $hotel->ubicacion->latitud; ?> , lng: <?php echo $hotel->ubicacion->longitud; ?>},
            zoom: 16
          });

          var marker1 = new google.maps.Marker({
            position: {lat: <?php echo $hotel->ubicacion->latitud; ?> , lng: <?php echo $hotel->ubicacion->longitud; ?>},
            map: map1,
          });

  }
</script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.nav.js')); ?>"></script>

<script type="text/javascript">
   
   $('#onepage').onePageNav({
    start: function() {
      
    },
    end: function() {
      
    }
   });

   function habitacion(id,name,link){

    $('#habitacion_title').html(name);
    $('#habitacion_body').html(`
        <center>
            <div class="loader">Loading...</div>
          </center>`);
    $('#habitacion_modal').modal('show');

    $.ajaxSetup({
      headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')     
      }
    }); 

    $.ajax({
      url:link,       
      type:'post',      
      success: function (response) {
        $('#habitacion_body').html(response);                                      
      },
    });
      
   }
</script>

<script src="<?php echo e(asset('js/fotorama.js')); ?>"></script>
<script src="<?php echo e(asset('js/plyr.js')); ?>" type="text/javascript"></script>

<script type="text/javascript">
  const player = new Plyr('#player',{
  controls: [
      'play-large', // The large play button in the center
      'play', // Play/pause playback
      'progress', // The progress bar and scrubber for playback and buffering
      'current-time', // The current time of playback
      'duration', // The full duration of the media
      'mute', // Toggle mute
      'volume', // Volume control
      'fullscreen', // Toggle fullscreen
  ],
});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/guatehoteles/public_html/resources/views/hotel_single.blade.php ENDPATH**/ ?>