<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Servicios;

class SubserviciosController extends Controller
{
    public function index($id){

    	$servicios = Servicios::where('id_servicio',$id)->orderby('id','desc')->get();
    	$name = Servicios::find($id)->servicio;
    	$i=1;
    	return view('admin.servicios.subservicios.index',compact('servicios','i','name','servicios','id'));
    }

    public function create($id){
    	$id_servicio = $id;
    	return view('admin.servicios.subservicios.create',compact('id_servicio'));
    }

    public function store($id, Request $request){

        $buscar = Servicios::all()->where('servicio',$request->servicio)->where('id_servicio',$id_servicio)->count();

        if ($buscar >0) {
            return redirect()->back()->with('error_servicio','El servicio '.$request->servicio.' ya se encuentra registrado');
        }

        $servicio = new Servicios();
        $servicio->servicio = $request->servicio;
        $servicio->id_servicio = $id;
        $servicio->save();

        return redirect()->route('subservicios.index',$id)->with('success','Registrado')->with('mensaje','Servicio registrado con éxito');
    }

    public function edit($id_servicio,$id){

    	$servicio = Servicios::find($id);
        return view('admin.servicios.subservicios.edit',compact('servicio','id_servicio'));
    }

    public function update($id_servicio,$id, Request $request){

        $buscar = Servicios::all()->where('servicio',$request->servicio)->where('id','!=',$id)->where('id_servicio',$id_servicio)->count();

        if ($buscar >0) {
            return redirect()->back()->with('error_servicio','El servicio '.$request->servicio.' ya se encuentra registrado');
        }

        $servicio = Servicios::find($id);
        $servicio->servicio = $request->servicio;

        $file    = $request->file('foto');

        if ($file) {
            $file    = $request->file('foto');
            $name    = $file->getClientOriginalName();
            $code = generar_code(4);
            $name = $code.'-'.$name;
            \Storage::disk('servicios')->put($name,  \File::get($file));
            $url_img = "/img/servicios/".$name;

            $servicio->img = $url_img;
            $servicio->principal = 'S';
        }

        $servicio->save();

        return redirect()->route('subservicios.index',$id_servicio)->with('success','Actualizado')->with('mensaje','Servicio actualizado con éxito');
    }
}
