
@extends('admin.layouts.app')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="javascript:void(0);">Inicio</a></li>
    <li class="breadcrumb-item" aria-current="page"><span>Aprobaciones</span></li>
@endsection

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('css/datatables.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('css/dt-global_style.css')}}">
@endsection

@section('content')
<div class="row layout-spacing layout-top-spacing feather-icon">
    <div id="font-icon_feather" class="col-lg-12">
        <div class="statbox widget box box-shadow">
            <div class="widget-content widget-content-area bx-top-6">
                <div class="icon-section">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="row">
                                <div class="col">
                                    <h4>{{$titulo}}</h4>
                                </div>
                            </div>                            
                           
                            <div class="table-responsive mb-4 mt-4">
                                <table id="zero-config" class="table table-hover" style="width:100%; text-align: center;">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Hotel</th>                                            
                                            <th class="no-content"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($hoteles as $key)
                                            <tr>
                                                <td>{{$i++}}</td>
                                                <td>{{$key->hotel->nombre}}</td>
                                                <td>
                                                    <a href="{{route('hotel.single',$key->hotel->url)}}" 
                                                        target="_black" 
                                                        class="bs-tooltip" 
                                                        data-toggle="tooltip" data-placement="bottom"
                                                         title="Ver más">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                                        </a>

                                                        <a 
                                                        @if($link==1)
                                                            href="javascript:aprobar('{{route('aprobaciones.inguat.aprobar')}}','{{$key->hotel->nombre}}',{{$key->id}})"
                                                        @endif 

                                                        @if($link==2)
                                                            href="javascript:aprobar('{{route('aprobaciones.guatehoteles.aprobar')}}','{{$key->hotel->nombre}}',{{$key->id}})"
                                                        @endif 

                                                        class="bs-tooltip text-success" 
                                                        data-toggle="tooltip" data-placement="bottom"
                                                         title="Aprobar">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check"><polyline points="20 6 9 17 4 12"></polyline></svg>
                                                        </a>

                                                        <a 
                                                        @if($link==1)
                                                            href="javascript:rechazar('{{route('aprobaciones.inguat.rechazar')}}','{{$key->hotel->nombre}}',{{$key->id}})"
                                                        @endif 

                                                        @if($link==2)
                                                            href="javascript:rechazar('{{route('aprobaciones.guatehoteles.rechazar')}}','{{$key->hotel->nombre}}',{{$key->id}})"
                                                        @endif
                                                        class="bs-tooltip text-danger" 
                                                        data-toggle="tooltip" data-placement="bottom"
                                                         title="Rechazar">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                                                        </a>
                                                </td>
                                            </tr>
                                        @endforeach                                   
                                    </tbody>
                                     <tfoot>
                                        <tr>
                                            <th> </th>
                                            <th> </th>
                                            <th> </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>                           
                        </div>
                    </div>
                </div>         
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    
    <form id="update-form" action="#" method="POST" style="display: none;">
        @csrf
        <input type="hidden" name="id" value="" id="data">
    </form>

    <script type="text/javascript" src="{{asset('js/datatables.js')}}"></script>

    <script type="text/javascript" src="{{asset('js/table-data.js')}}"></script>

    <script type="text/javascript">

        table_data('#zero-config');

        function rechazar(link,name,id){
            swal({   
                title: "¿Estás seguro?",
                text: "¿Deseas rechazar a: "+name+"?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Si, rechazar!",
                cancelButtonText: "No, cancelar!",
                closeOnConfirm: false,
                closeOnCancel: false 
            }, function(isConfirm){
                if (isConfirm) {
                    $('#data').val(id);
                    $('#update-form').attr('action',link);
                    $('#update-form').submit();
                } else {
                    swal("Cancelado", name+" no fue rechazado", "error");
                }
            });
        }

        function aprobar(link,name,id){
            swal({   
                title: "¿Estás seguro?",
                text: "¿Deseas aprobar a: "+name+"?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#8bc34a",
                confirmButtonText: "Si, aprobar!",
                cancelButtonText: "No, cancelar!",
                closeOnConfirm: false,
                closeOnCancel: false 
            }, function(isConfirm){
                if (isConfirm) {
                    $('#data').val(id);
                    $('#update-form').attr('action',link);
                    $('#update-form').submit();
                } else {
                    swal("Cancelado", name+" no fue aprobado", "error");
                }
            });
        }
    </script>
@endsection